/**
 * aconno helpers
 * Set of general purpose fuctions used within aconno projects
 *
 */

#include "mbed.h"
#include "aconnoHelpers.h"
#include "stdlib.h"
#include "gnss.h"
#include "aconnoConfig.h"

bool getGPSData(char *location, GnssSerial *gnss, uint32_t timeoutS)
{
	int gnssReturnCode;
	int length;
	char buffer[505];
	bool gotLocationFlag = false;
	int begin;
	int end;

	if(!timeoutS)
	{
		// Max number of seconds
		timeoutS -= 1;
	}

	Timer timeoutTimer;
	timeoutTimer.start();
	begin = timeoutTimer.read();
	do
	{
		gnssReturnCode = gnss->getMessage(buffer, sizeof(buffer));
		if (gnssReturnCode > 0)
		{
			// Msg from GNSS module received
			length = LENGTH(gnssReturnCode);
			if ((PROTOCOL(gnssReturnCode) == GnssParser::NMEA) && (length > 6))
			{
				// Talker is $GA=Galileo $GB=Beidou $GL=Glonass 
				// $GN=Combined $GP=GNSS
				if ((buffer[0] == '$') || buffer[1] == 'G')
				{
					if (CHECK_TALKER("GLL"))
					{

						double latitude = 0, longitude = 0;
						char ch;
						if (gnss->getNmeaAngle(1, buffer, length, latitude) &&
							gnss->getNmeaAngle(3, buffer, length, longitude) &&
							gnss->getNmeaItem(6, buffer, length, ch) && 
											 (ch == 'A'))
						{
							sprintf(location, "%.5f %.5f", latitude, longitude);
							printf("Got location!\r\n");
							gotLocationFlag = true;
						}
					}
				}
			}
		}
		end = timeoutTimer.read();
	} while (!gotLocationFlag && (end - begin) < timeoutS);
	
	printf("Location time: %d\r\n", (end - begin));
	return gotLocationFlag;
}

