/**
 * U-Blox SARA nb-iot module class
 * Made by Jurica Resetar @ aconno
 * More info @ aconno.de
 */

#include "mbed.h"
#include "uBloxSara.h"
#include "udp.h"
#include "onboard_modem_api.h"

UBloxSara::UBloxSara(ATCmdParser *at, Udp udp):
	_at(at), _udp(udp)
{
}

bool UBloxSara::setup()
{
	bool success = false;

    /* Initialize GPIO lines */
    onboard_modem_init();

    /* Give modem a little time to settle down */
    wait_ms(250);

    if(!CUSTOM_BOARD)
    {
        // DO NOT CALL THIS IF YOU WORK ON ACONNO CUSTOM MADE BOARD
        // POWER UP PIN (PE_14) IS CONNECTED ON OC DIGITAL OUTPUT
        // AND POWER UP PIN IS NOT CONNECTED ON SARA MODULE
        onboard_modem_power_up();
    }
    
    wait_ms(5000);

    sendCommand("AT+CFUN=1");

    // Set AT parser timeout to 1sec for AT OK check
    _at->set_timeout(1000);

	return true;

    printf("Checking for AT response from the modem\r\n");
    for (int retry_count = 0; !success && (retry_count < 20); retry_count++)
    {
        printf("...wait\r\n");
        // The modem tends to sends out some garbage during power up.
        _at->flush();

        // AT OK talk to the modem
        if (_at->send("AT")) {
            wait_ms(100);
            if (_at->recv("OK")) {
                success = true;
            }
        }
    }
    // Increase the parser time to 8 sec
    _at->set_timeout(8000);

    if (success)
	{
        printf("Configuring the modem...\r\n");
        // Turn off modem echoing and turn on verbose responses
        //success = _at->send("AT+CMEE=1");
    }
    return success;
}

void UBloxSara::sendCommand(char *command)
{
	char buffer[505];
    for (int i=0; i<505; i++)buffer[i]=0;
    printf("Sending the following command:");
    printf(command);
    printf("\r\n");

    if (!_at->send(command)) {
        printf("Failed!\r\n");
        return;
    }
    printf("Response:\r\n");
    _at->read(buffer,500);
    printf(buffer);
    printf ("\r\n");
}

void UBloxSara::checkNetworkStatus(char *response)
{
    char command[] = "AT+NUESTATS";
    printf("Checking network status...");

    if(!_at->send(command))
    {
        printf("Failed!\r\n");
        return;
    }
    printf("Response:\r\n");
    _at->read(response,500);
    printf(response);
    printf ("\r\n");
}

void UBloxSara::sendUdpMsg(char *msg, char *flags)
{
	char myCommandbuffer[250];
    int msgSize = strlen(msg);
    char data[msgSize*2];
    int flagsSize = strlen(flags);
    char flagsHex[flagsSize*2];

    // Create UDP socket on port 'port' 
    sprintf(myCommandbuffer,"AT+NSOCR=\"DGRAM\",17,%d",_udp._port); 
    sendCommand(myCommandbuffer); 
	// Prepaire data for transmition
    for (int i=0, j=0; i<msgSize; i++, j+=2)
    {
		// Take i-th byte and make hex string out of it
	    sprintf((data+j),"%x", *(msg+i));
	}
    for(int i=0, j=0; i<flagsSize; i++, j+=2)
    {
        // Take i-th byte and make hex string out of it
        sprintf((flagsHex+j), "%x", *(flags+i));
    }

	sprintf(myCommandbuffer,"AT+NSOST=0,\"%s\",%d,%d,\"%s\"",
		_udp._ip, _udp._port, msgSize, data);

    //msgSize += strlen(flags);
    //sprintf(myCommandbuffer,"AT+NSOST=0,\"%s\",%d,%d,\"%s%s\"",
	//	_udp._ip, _udp._port, msgSize, flagsHex, data);
	sendCommand(myCommandbuffer);
}

#define SHORT_DELAY_MS      (1000)
uint8_t UBloxSara::connectNB()
{
	sendCommand("at+NCONFIG=\"AUTOCONNECT\",\"FALSE\"");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("at+NCONFIG=\"CR_0354_0338_SCRAMBLING\",\"TRUE\"");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("at+NCONFIG=\"CR_0859_SI_AVOID\",\"TRUE\"");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("at+NCONFIG?");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("at+cfun=0");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("AT+CGDCONT=1, \"IP\",\"nb.inetd.gdsp\"");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("at+cfun=1");
    wait_ms(SHORT_DELAY_MS);

    sendCommand("at+cimi");
    wait_ms(SHORT_DELAY_MS);

    sendCommand("at+cgatt=1");
    wait_ms(SHORT_DELAY_MS);

    sendCommand("at+cops=1,2,\"26202\"");
    wait_ms(5000);
  	sendCommand("at+cereg?");
    wait_ms(5000);
    sendCommand("AT+CSQ");
    wait_ms(5000);
    sendCommand("AT+COPS?");
    sendCommand("AT+NBAND?");
    sendCommand("AT+NBAND=20");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("AT+NUESTATS");
    wait_ms(SHORT_DELAY_MS);
    sendCommand("AT+CGATT?");
    wait_ms(5000);
    sendCommand("AT+CGPADDR");
    wait_ms(SHORT_DELAY_MS);
}
