/**
 * Collection of all tasks  
 * Made by Jurica @ aconno
 * More info @ aconno.de
 * 
 */

#ifndef __TASKS_H__
#define __TASKS_H__

#include "mbed.h"
#include "aconnoConfig.h"
#include "uBloxSara.h"
#include "gnss.h"

struct myParams_t
{
    GnssSerial *gnss;
    UBloxSara *sara;
};

enum locationFlag_t
{
    OLD,
    NEW
};

enum MainStates
{
    STATE_IDLE,
    STATE_ALARM,
    STATE_ALARM_OFF,
    STATE_LIS_DETECTION
};

void idleCallback();
void alarmCallback(myParams_t *myParams);
void alarmOffCallback();
void movementCallback();
void gnssLocationCallback(GnssSerial *gnss);

#endif // __TASKS_H__