/**
 * Collection of all tasks  
 * Made by Jurica @ aconno
 * More info @ aconno.de
 * 
 */

#include "tasks.h"
#include "aconnoHelpers.h"
#include "gnss.h"
#include "aconnoConfig.h"

extern volatile MainStates state;
extern char locationGlobal[5*UDP_MSG_SIZE_B];
extern Thread alarmState;
locationFlag_t locationFlagGlobal = OLD;

void idleCallback()
{
    while(1)
    {
        Thread::signal_wait(IDLE_SIGNAL);
        Thread::signal_clr(IDLE_SIGNAL);
        printf("In idle thread.\r\n");
        while(state == STATE_IDLE)
        {   
            wait_ms(1000);
        }
    }
}

void alarmCallback(myParams_t *myParams)
{
    char udpMsg[UDP_MSG_SIZE_B];
    
    while(1)
    {
        while(state == STATE_ALARM)
        {
            Thread::signal_wait(LOCATION_SEARCH_DONE);
            Thread::signal_clr(LOCATION_SEARCH_DONE);
            if(locationFlagGlobal)
            {
                sprintf(udpMsg, "$location_flag:%s;$type:NEW;",locationGlobal);
            }
            else
            {
                sprintf(udpMsg, "$location_flag:%s;$type:OLD;",locationGlobal);
            }
            printf("Sending location on server...\r\n");
            printf("%s\r\n", udpMsg);
            myParams->sara->sendUdpMsg(udpMsg);
            wait_ms(5000);
        }
    }
}

void alarmOffCallback()
{
    while(1)
    {   
        Thread::signal_wait(ALARM_OFF_SIGNAL);
        Thread::signal_clr(ALARM_OFF_SIGNAL);
        printf("In alarm off thread.\r\n");
        while(state == STATE_ALARM_OFF)
        {
            wait_ms(1000);
        }
    }
}

void movementCallback()
{
    while(1)
    {
        while(state == STATE_LIS_DETECTION)
        {
            printf("In movement thread.\r\n");
            wait_ms(1000);
        }
    }
}

void gnssLocationCallback(GnssSerial *gnss)
{
    while(1)
    {
        while(state == STATE_ALARM)
        {
            if(getGPSData(locationGlobal, gnss, MAX_TIME_GNSS_WAIT_S))
            {
                printf("New location.\r\n");
                locationFlagGlobal = NEW;
            }
            else
            {
                printf("Old location.\r\n");
                locationFlagGlobal = OLD;
            }
            alarmState.signal_set(LOCATION_SEARCH_DONE);
            Thread::wait(UPDATE_LOCATION_TIME_MS);
        }
    }
}

