/**
 * aconnoConfig.h
 * Config file for SAP project
 * Made by Jurica Resetar @ aconno
 * More info @ aconno.de
 * All rights reserved
 */

#ifndef __ACONNO_CONFIG_H__
#define __ACONNO_CONFIG_H__

#define USE_C030_BOARD			(1)

#define USER_BUTTON				(PC_13)
#define USER_LED				(PE_7)

/* Definitions */
#define OUTPUT_ENTER_KEY  "\r"
#define AT_PARSER_BUFFER_SIZE   (256)
#define AT_PARSER_TIMEOUT       (8*1000) // Milliseconds
#define STANDBY_TIME_SECONDS 	(25)
#define TARGET_STM				(1)
#define UDP_MSG_SIZE_B			(50)

// Max wait time to get new location [s]
#define MAX_TIME_GNSS_WAIT_S    (10)
#define START_ALARM_S           (1)
#define STOP_ALARM_S            (5)
#define BUTTON_PRESSED_SIGNAL   (0x12002300)
#define ALARM_SIGNAL            (0x12341230)   
#define ALARM_OFF_SIGNAL        (0x12341231)
#define IDLE_SIGNAL             (0x12341232)
#define LOCATION_SEARCH_DONE    (0x12341233)

#define UPDATE_LOCATION_TIME_MS (5000)

#endif // __ACONNO_CONFIG_H__
