/*
* Aconno Board Support Packet
* Made by Jurica Resetar @ aconno
* More info @ aconno.de
*/

#ifndef __STM_BSP_H__
#define __STM_BSP_H__

#include "mbed.h"

#define BUTTON_TRUE		(1)
#define BUTTON_FALSE	(!BUTTON_TRUE)

#define USER_BUTTON_PIN     (PC_13)
#define RED_LED_PIN			(PE_4)
#define GREEN_LED_PIN		(PE_3)
#define BLUE_LED_PIN		(PE_1)

extern DigitalOut redLed;
extern DigitalOut blueLed;
extern DigitalOut greenLed;


enum led_state{
    LED_ON = 0,
    LED_OFF = 1
};

void bsp_init();
int bsp_read_button();
void bsp_ctrl_led(DigitalOut led, led_state state);
void bsp_toggle_led(DigitalOut led);

#endif // __STM_BSP_H__
