/*
 * Made by Jurica @ aconno
 * All rights reserved
 *
 */

#ifndef SERVICE_H
#define SERVICE_H

#define TIMESTAMP_SIZE_B	(6)

static const uint16_t SERVICE_UUID = 0xA3B6;
static const uint16_t NTP_CHARACTERISTIC_UUID = 0x33CC;

class Service{
    public:
        Service(BLEDevice &ble) : ble(ble), time(NTP_CHARACTERISTIC_UUID, 0){
        // Add characteristics to the table
        GattCharacteristic *characteristics[] = {&time};
        GattService service(SERVICE_UUID, characteristics,
            sizeof(characteristics)/sizeof(*characteristics));
        ble.addService(service); // Add service in the BLE
        }
        inline GattAttribute::Handle_t getTimeCharacteristicHandle()
        {
            return time.getValueHandle();
        }
    private:
        BLEDevice &ble;
        // New characteristics names time
        WriteOnlyArrayGattCharacteristic<uint8_t, TIMESTAMP_SIZE_B> time;
};
#endif
