/*
* Made by Jurica @ aconno
* All rights reserved
*
*/

#include "aconnoBLE.h"
#include "BLEConfig.h"
#include "ble/BLE.h"
#include "GapAdvertisingData.h"
#include "BLEData.h"
#include "service.h"

extern advertisingFormat manufacturerSpecificData;
static EventQueue eventQueue(EVENT_COUNT * EVENTS_EVENT_SIZE);
Service *service;


void onBleInitError(BLE &ble, ble_error_t error)
{
    /* Avoid compiler warnings */
    (void) ble;
    (void) error;
    /* Initialization error handling should go here */
}

void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context)
{
    BLE &ble = context->ble;
    eventQueue.call(Callback<void()>(&ble, &BLE::processEvents));
}

EventQueue *getBLEEventQueue(void)
{
    return &eventQueue;
}

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params){
    BLE &ble = params->ble;

    /* setup NTP service and characteristic */
    service = new Service(ble);
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gap().onConnection(onConnectionCallback);
    ble.gattServer().onDataWritten(onDataCallback);

    /* setup event handling */
    ble.onEventsToProcess(scheduleBleEventsProcessing);

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(
        GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA,
        (uint8_t *)&manufacturerSpecificData, sizeof(advertisingFormat));
    ble.gap().setAdvertisingInterval(A_ADV_INTERVAL_MS);
    ble.gap().startAdvertising();
}

void onConnectionCallback(const Gap::ConnectionCallbackParams_t *params){
    //printf("Device is connected.\n");
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params){
    //printf("Device is disconnected.\n");
    BLE::Instance().gap().startAdvertising();
}

void onDataCallback(const GattWriteCallbackParams *params){
    if(params->handle == service->getTimeCharacteristicHandle()){
    }
}
