/*
 * Aconno BLE template
 * Made by Jurica @ aconno
 * All rights reserved
 *
 */

#ifndef ACONNO_BLE_H
#define ACONNO_BLE_H

#include "mbed.h"
#include "ble/BLE.h"
#include "GapAdvertisingData.h"

/**
 * Ble init error callback
 * @param ble   referance to BLE object
 * @param error Error code
 */
void onBleInitError(BLE &ble, ble_error_t error);

/**
 * BLE event callback.
 * @param context
 */
void scheduleBleEventsProcessing(
   BLE::OnEventsToProcessCallbackContext* context);

/**
 * Get pointer to BLE event queue.
 * @return  BLE event queue.
 */
EventQueue *getBLEEventQueue(void);

/**
 * ble init complete callback
 * @param params
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params);

/**
 * onConnection callback
 * @param params ConnectionCallbackParams_t
 */
void onConnectionCallback(const Gap::ConnectionCallbackParams_t *params);

/**
 * Disconnection callback
 * @param params DisconnectionCallbackParams_t
 */
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params);

/**
 * onDataWritten callback
 * @param params GattWriteCallbackParams
 */
void onDataCallback(const GattWriteCallbackParams *params);

#endif // ACONNO_BLE_H
