/*
 * Made by Jurica @ aconno
 * All rights reserved
 *
 */

#ifndef BLE_DATA_H
#define BLE_DATA_H

typedef struct __attribute__((packed, aligned(1))) _timestamp
{
    uint64_t time : 48;
} timestampFormat;

typedef struct __attribute__((packed, aligned(1))) _headerFormat
{
    uint16_t ID;
} headerFormat;

typedef struct __attribute__((packed, aligned(1))) _diagnoseFlagsFormat
{
    uint8_t powerSupplyConnected : 1;
    uint8_t valveSwitchedOn : 1;
    uint8_t valveSwitchedOff : 1;
    uint8_t shortCircuitDetected : 1;
    uint8_t warningLife : 1;
    uint8_t failureLife : 1;
    uint8_t internSupplyVoltageLow : 1;
} diagnoseFlagsFormat;

typedef struct __attribute__((packed, aligned(1))) _systemState
{
    unsigned int switchCounter;
    uint8_t operatingHours[3];
    int8_t electronicsTemp;
    int16_t coilTemp;
    __attribute__((packed)) int8_t powerSuppyVoltage;
    __attribute__((packed)) int8_t internPowerSupplyVoltage;
    __attribute__((packed)) int16_t lifeTime;
    __attribute__((packed)) uint16_t coilResistance;
    __attribute__((packed)) uint8_t magnetoCurrent;
} systemStateFormat;

typedef struct __attribute__((packed, aligned(1))) _advertisingFormat{
    __attribute__((packed, aligned(1))) headerFormat header;
    __attribute__((packed, aligned(1))) diagnoseFlagsFormat diagnoseFlags;
    __attribute__((packed, aligned(1))) timestampFormat timestamp;
    __attribute__((packed, aligned(1))) systemStateFormat systemState;
} advertisingFormat;

#endif // BLE_DATA_H
