/*
 * Made by Jurica Resetar and Karlo Milicevic @ aconno, 2017
 * jurica_resetar@yahoo.com
 * aconno.de  
 * All rights reserved 
 *
 */

#ifndef ACD_NRF52_SAADC_H
#define ACD_NRF52_SAADC_H

#include "mbed.h"

#define NUM_OF_CHANNELS     (8)

/** NRF52 adc library 
 */
class NRF52_SAADC{
    public:
        /** Initializes adc module
         */
        NRF52_SAADC(uint8_t analogIn);
        NRF52_SAADC(uint8_t pPin, uint8_t nPin);
        int16_t read();
        
        ~NRF52_SAADC();
        bool addDiffChannel(uint8_t pInput, uint8_t nInput);
        
        /** @returns
         *     0 on success, 1 otherwise
         */
        bool addChannel(uint8_t pin);
        void calibrate();
        /** Reads analog pins
         */
        void updateData();
        /** @returns
         *     pointer to analog input data - data is stored in channel add order
         */
        int16_t *getData() { return data; }
        
        static uint8_t channelCounter;
    private:
        static int16_t data[sizeof(int16_t)*8]; // 8 channels
        uint8_t channel;
        
};
 
 #endif // ACD_NRF52_SAADC_H