/*
 * Made by Jurica Resetar and Karlo Milicevic @ aconno, 2017
 * jurica_resetar@yahoo.com
 * aconno.de  
 * All rights reserved 
 *
 */
  
#include "acd_nrf52_saadc.h"

uint8_t NRF52_SAADC::channelCounter = 0;
int16_t NRF52_SAADC::data[sizeof(int16_t)*NUM_OF_CHANNELS] = {0};

NRF52_SAADC::NRF52_SAADC(uint8_t analogIn): channel(channelCounter){
    if(!channelCounter){
        // Do this for the first object only
        NRF_SAADC->ENABLE = 1;
        NRF_SAADC->RESULT.PTR =(uint32_t)data;  // Pass pointer to results buffer
        NRF_SAADC->RESOLUTION = 3;
        calibrate();
    }
    if(channelCounter < 8){
        NRF_SAADC->CH[channel].PSELP = analogIn + 1;     
        NRF_SAADC->CH[channel].CONFIG = 0x00021000; // reset
        channelCounter++;
        NRF_SAADC->RESULT.MAXCNT = channelCounter;
    }
}

NRF52_SAADC::NRF52_SAADC(uint8_t pPin, uint8_t nPin): channel(channelCounter){
    if(!channelCounter){
        // Do this for the first object only
        NRF_SAADC->ENABLE = 1;
        NRF_SAADC->RESULT.PTR =(uint32_t)data;  // Pass pointer to results buffer
        NRF_SAADC->RESOLUTION = 3;
        calibrate();
    }
    if(channelCounter < 8){
        NRF_SAADC->CH[channel].PSELP = pPin + 1;     
        NRF_SAADC->CH[channel].PSELN = nPin + 1;     
        NRF_SAADC->CH[channel].CONFIG = 0x00121200; // differential  input, Gain 1
        channelCounter++;
        NRF_SAADC->RESULT.MAXCNT = channelCounter;
    }
}

NRF52_SAADC::~NRF52_SAADC(){
    NRF_SAADC->ENABLE = 0;
}

int16_t NRF52_SAADC::read(){
    updateData();
    return data[channel];
}

void NRF52_SAADC::updateData(){
    NRF_SAADC->TASKS_START = 1;
    while(!NRF_SAADC->EVENTS_STARTED);
    NRF_SAADC->TASKS_SAMPLE = 1;
    for(uint8_t i = 0; i < channelCounter; ++i){
        while(!NRF_SAADC->EVENTS_RESULTDONE);
        while(!NRF_SAADC->EVENTS_DONE);
        while(!NRF_SAADC->EVENTS_END);
        while(NRF_SAADC->STATUS == 1); // while conversion is is progress
    }
    NRF_SAADC->TASKS_STOP = 1;
    while(!NRF_SAADC->EVENTS_STOPPED);
}

void NRF52_SAADC::calibrate(){
    NRF_SAADC->TASKS_CALIBRATEOFFSET = 1;
    while(!NRF_SAADC->EVENTS_CALIBRATEDONE);
}
