/*
 *   Made by Jurica Resetar @ aconno
 *   More info @ aconno.de
 *
 */

#ifndef MAIN_H
#define MAIN_H
 
#include "mbed.h"
#include "nrf52_uart.h"
#include "Lis2dh12.h"
#include "Lis2dh12_regs.h"
#include "aconno_ble.h"
#include "ble/BLE.h"
#include "GapAdvertisingData.h"

#define DEBUG               (0)
#define PRINT_ON_RTT        (0)
#define DEBUG_LED           (0)
#define NANO_MODULE         (1)
#define LSB_VALUE           (192)

#if NANO_MODULE
    #define I2C_DATA            (p2)
    #define I2C_CLK             (p3)
    #define INT_PIN1            (p10)
    #define INT_PIN2            (p9)
    #define ACC_POWER_PIN       (p13)
    #define RED_LED_PIN         (p12)
#else
    #define I2C_DATA            (p20)
    #define I2C_CLK             (p17)
    #define INT_PIN1            (p16)
    #define INT_PIN2            (p15)
    #define ACC_POWER_PIN       (p11)
    #define RED_LED_PIN         (p22)
#endif

#define BLE_ACTIVE_TIME_S   (0.4)
#define POWER_UP_DELAY_MS   (200)

#if PRINT_ON_RTT
    #include "SEGGER_RTT.h"
    #define printf(...)                      SEGGER_RTT_printf(0, __VA_ARGS__)
#else
    #define printf(...)
#endif

#define INT1_THRESHOLD      (20u)
#define INT1_DUR            (0x00)
    
#define ACC_INT_SIG         (0x00001020)    // Acc interrupt signal
#define DISABLE_BLE_SIG     (0x00001030)

#if DEBUG
    NRF52_UART uart(p12, p14, Baud9600);
    char buffer[255];
    #define SEND(...) {uint8_t len = sprintf(buffer, __VA_ARGS__); uartM.lock(); uart.send(buffer, len); uartM.unlock();}
#else
    #define SEND(...)
#endif

char memsI2CAddress = I2C_ADDRESS;
Mutex uartM;
Thread uartT;
Thread bleT;
Thread measureT;

DigitalOut AccVcc(ACC_POWER_PIN);
DigitalOut redLed(RED_LED_PIN);
InterruptIn INT1(INT_PIN1);
//InterruptIn INT2(INT_PIN2);
I2C i2c(I2C_DATA,I2C_CLK);
Lis2dh12 mems(&i2c, memsI2CAddress);
Ticker bleTicker;

#endif
