/* 
 * aconno.de
 * Made by Jurica Resetar
 * All right reserved 
 *
 */

#include "main.h"

void disableI2C(){
    NRF_TWI0->ENABLE = 0;
    NRF_TWI0->PSELSCL = 0xFFFFFFFF;
    NRF_TWI1->ENABLE = 0;
    NRF_TWI1->PSELSCL = 0xFFFFFFFF;
    NRF_TWIM0->ENABLE = 0;
    NRF_TWIM0->PSEL.SCL = 0x80000000;
    NRF_TWIM0->PSEL.SDA = 0x80000000;
    NRF_TWIM1->ENABLE = 0;
    NRF_TWIM0->PSEL.SCL = 0x80000000;
    NRF_TWIM0->PSEL.SDA = 0x80000000;
    DigitalOut foo(I2C_DATA);
    DigitalOut bar(I2C_CLK);
    foo = 1;
    bar = 1;
}

void disableBle(){
    bleTicker.detach();
    bleT.signal_set(DISABLE_BLE_SIG);
}

void int1Handler(){
    __disable_irq();
    I2C i2c(I2C_DATA,I2C_CLK);
    mems.clearIntFlag();
    bleT.signal_set(ACC_INT_SIG);
    bleTicker.attach(disableBle, BLE_ACTIVE_TIME_S);
    disableI2C();
    __enable_irq();
    
}


void bleF(BLE *ble){
    // Thread function for managing BLE radio
    // First wait for acc interrupt signal
    while(true){
        Thread::signal_wait(ACC_INT_SIG);
        Thread::signal_clr(ACC_INT_SIG);
        //I2C i2c(I2C_DATA,I2C_CLK);
        
        printf("\r\n\r\n**********************\r\n");
        printf("Interrupt on accelerometer.\r\n");
        printf("X acceleration data: %d [mg]\r\n", mems.readXAxis()*LSB_VALUE);
        printf("Y acceleration data: %d [mg]\r\n", mems.readYAxis()*LSB_VALUE);
        printf("Z acceleration data: %d [mg]\r\n", mems.readZAxis()*LSB_VALUE);
        printf("******************************\r\n");
        
        //disableI2C();
        //__enable_irq();
        
        ble->gap().startAdvertising();
        printf("Ble advertisement is ON.\r\n");
        #if DEBUG_LED
            redLed = 0;
        #endif
        Thread::signal_wait(DISABLE_BLE_SIG);
        Thread::signal_clr(DISABLE_BLE_SIG);
        ble->gap().stopAdvertising();
        printf("Ble advertisement is OFF.\r\n\r\n");
        #if DEBUG_LED
            redLed = 1;
        #endif
    }
}

void measureF( void )
{
    while(1){
        printf("X acceleration data: %d [mg]\r\n", mems.readXAxis()*LSB_VALUE);
        printf("Y acceleration data: %d [mg]\r\n", mems.readYAxis()*LSB_VALUE);
        printf("Z acceleration data: %d [mg]\r\n\r\n", mems.readZAxis()*LSB_VALUE);
        wait_ms(100);
    }
}

int main(){
    
    printf("Main program started.\r\n");
    
    NRF_NVMC->CONFIG = 0x00000002;      // Erase enable UICR
    NRF_NVMC->ERASEUICR = 0x00000001;   // Erase all
    NRF_NVMC->CONFIG = 0x00000001;      // Write enable UICR
    NRF_UICR->NFCPINS = 0xFFFFFFFE;     // Change NFC to GPIO function
    
    redLed = 1;
    AccVcc = 1;
    wait_ms(POWER_UP_DELAY_MS);

    INT1.rise(int1Handler);
    NRF_GPIO->PIN_CNF[INT_PIN1] &= 0xFFFFFFF3;  // NO PullUps
    
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    
    mems.setMode(LOW_POWER);
    
    mems.enableAxes(X_axis);
    mems.enableAxes(Y_axis);
    mems.enableAxes(Z_axis);    
    mems.setODR(ODR_50Hz);
    mems.setScale(_16g);
    mems.int1Setup(0x40);       // IntActivity 1 driven to INT1 pad
    mems.int1Latch(0x01);       // Enable int1 latch
    mems.int1Threshold(INT1_THRESHOLD); 
    mems.int1Duration(INT1_DUR);            
    mems.int1Config(0x2A);      // Enable XHigh, YHigh and ZHigh
    
    bleT.start(callback(bleF, &ble));   // Start bleT
    //measureT.start(callback(measureF));
    
    while(1){
        disableI2C();
        Thread::wait(0xFFFFFFFF);
    }
}
