/*
 * Made by Jurica Resetar @ aconno
 * jurica_resetar@yahoo.com
 * More info @ aconno.de
 *
 * All rights reserved
 *
 */
 
#include "mbed.h"
#include "aconno_i2s.h"

aconno_i2s::aconno_i2s(){
    // Constructor
}

void aconno_i2s::init(uint8_t dataOutPin, uint8_t LrckPin, uint8_t SckPin, uint16_t bufferSize_B, uint8_t *dataPointer){
    NRF_I2S->CONFIG.RXEN = 0;       // Disable reception
    NRF_I2S->CONFIG.MCKEN = 1;      // Enable MCK generator
    
    NRF_I2S->CONFIG.MCKFREQ = 0x10000000;   // DIV 31
    NRF_I2S->CONFIG.RATIO = 0;              // Ratio = 32x
    
    NRF_I2S->CONFIG.SWIDTH = 0;             // Sample width = 8 bit
    NRF_I2S->CONFIG.ALIGN = 0;              // Alignment = Right
    NRF_I2S->CONFIG.FORMAT = 0;             // Format = I2S
    NRF_I2S->CONFIG.CHANNELS = 0;           // Use stereo
    
    NRF_I2S->PSEL.LRCK = LrckPin;           // LRCK routed to pin 26
    NRF_I2S->PSEL.SDOUT = dataOutPin;          // SDOUT routed to pin 28
    NRF_I2S->PSEL.SCK = SckPin;             // SCK routed to pin 30
    NRF_I2S->PSEL.MCK = 0x80000000;         // MCK disconnected
    NRF_I2S->PSEL.SDIN = 0x80000000;        // SDIN disconnected
    
    NRF_I2S->TXD.PTR = (uint32_t)dataPointer;
    NRF_I2S->RXTXD.MAXCNT = bufferSize_B/4;  // Div with 4 cuz that's number of 32 bit words
}

void aconno_i2s::sendData(){
    /* 
     *  I2S bits go from MSB to LSB on the bus
     */
     
    NRF_I2S->EVENTS_TXPTRUPD = 0;
    NRF_I2S->ENABLE = 1;
    NRF_I2S->TASKS_START = 1;    
    
    while(!NRF_I2S->EVENTS_TXPTRUPD);    // Wait for the data to be send
    NRF_I2S->EVENTS_TXPTRUPD = 0;
    while(!NRF_I2S->EVENTS_TXPTRUPD);    // Wait for the data to be send
    NRF_I2S->EVENTS_TXPTRUPD = 0; 
    NRF_I2S->TASKS_STOP = 1;
    while(!NRF_I2S->EVENTS_STOPPED);
    NRF_I2S->ENABLE = 0;
}
 
 