
// Template allows you to use 'constant' values on non-constant places (XD)
template<uint8_t dataSize>

class ACKService{
    public:
        const static uint16_t ACK_SERVICE_UUID = 0xA000;
        const static uint16_t ACK_CHARA_UUID = 0xA001;

        ACKService(BLEDevice &_ble, uint8_t *_initValues) : ble(_ble), ACK(ACK_CHARA_UUID, _initValues){
                GattCharacteristic *charTable[] = {&ACK};     // Add characteristick in table
                GattService AckService(ACK_SERVICE_UUID, charTable, sizeof(charTable)/sizeof(GattCharacteristic *));   
                ble.addService(AckService); // Add service in the BLE
        }
    private:
        BLEDevice &ble;
        // Create new characteristic
        WriteOnlyArrayGattCharacteristic<uint8_t, dataSize> ACK;
};