/*
 *
 * This simple example is to demonstrare usage of pwm driver made by Jurica Reseta
 * @ aconno
 * jurica_resetar@yahoo.com
 * aconno.de
 * All right reserved
 *
 */
 
#include "mbed.h"
#include "acd52832_bsp.h"

#define USE_PWMOUT     (1)

#if USE_PWMOUT
    PwmOut led(PIN_LED);
#endif

int main(){
    uint8_t counter;
    float value = 0.0;
    float step = 0.025;
    
    #if !USE_PWMOUT
        NRF_PWM0->PSEL.OUT[0] = ((1<<31) || 26) ;
        NRF_PWM0->ENABLE = 1;
        NRF_PWM0->MODE = 0;     // Up counting
        NRF_PWM0
    #endif
    
    #if USE_PWMOUT
        led.period(0.0001);
        led.write(1.0);
    #endif 
    
    while(1){
        for(counter=0; counter < uint8_t((1.0/step)); counter++){
            led.write(value);
            value += step;
            wait_ms(25);
        }
        if(value>1.0) value=0.0;
        led.write(value);
    }
}