/* Copyright (c) 2016 Aconno. All Rights Reserved.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 */

#include "mbed.h"
#include "GDEP015OC1.h"
#include "pictures.h"

SPI spi(p3, NC, p4);
GDEP015OC1 epd = GDEP015OC1(spi, p5, p6, p7, p8);

int main(){
    epd.empty();
    epd.writeFull();
    while(true){
        for(uint16_t x=0;x<5000;x++)
            epd.fill(ir0[x], x);
        epd.write();
        wait_ms(500);
        for(uint16_t x=0;x<5000;x++)
            epd.fill(ir1[x], x);
        epd.write();
        wait_ms(500);
    }
}