/* Copyright (c) 2016 Aconno. All Rights Reserved.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 */
 
#include "mbed.h"
#include "acd52832_bsp.h"

#define V0 0.5    //In volts
#define TC 0.01   //In volts
#define VCC (3.3)

#define RX  (p25)
#define TX  (p26)

// initialize serial port
Serial pc(TX, RX);

AnalogIn tempVoltage (ADC_TEMP);
DigitalOut Hot(PIN_LED_RED);
DigitalOut Cold(PIN_LED_BLUE);

float getTemperature(float vout){
    return ((float)vout - (float)V0)/((float)TC);
}

int main(){
    
    // Clear LEDs
    Hot = 1;
    Cold = 1;
    
    while(1){
        pc.printf("Current temperature: %f\n", getTemperature(tempVoltage.read()*(float)VCC));
        if (getTemperature(tempVoltage.read()*(float)VCC) > 22){
            // Turn Hot ON
            Hot = 0;
            Cold = 1;
        }
        else{
            // Turn Cold On
            Hot = 1;
            Cold = 0;
        }
        wait(1);
    }
}