/*
 * Example to demonstrate usage of the nrf52's SAADC in differential working\
 * mode.
 *
 * Made by Jurica Resetar @ aconno
 * jurica_resetar@yahoo.com
 * More info @ aconno.de
 *
 * All rights reserved
 *
 */

#include "mbed.h"
#include "acd_nrf52_saadc.h"
#include "GDEP015OC1.h"

#define ANALOG_PIN_P     (4)
#define ANALOG_PIN_N     (5)
#define NUM_OF_DIFF_ADCs (4)

SPI spi(p3, NC, p4);
GDEP015OC1 epd = GDEP015OC1(spi, p5, p6, p7, p8);

int main(void){
    NRF52_SAADC *diffADCs[NUM_OF_DIFF_ADCs];
    /* Declare your ADCs here */
    /* Change NUM_OF_DIFF_ADCs in the header */
    diffADCs[0] = new NRF52_SAADC(ANALOG_PIN_P, ANALOG_PIN_N);
    diffADCs[1] = new NRF52_SAADC(ANALOG_PIN_N, ANALOG_PIN_P);
    
    uint8_t i; 
    float voltage[NUM_OF_DIFF_ADCs];
    char buffer[256];
    
    sprintf(buffer, "Differential ADC inputs:");
    epd.writeString(buffer, 30, 30, 0);
    epd.writeFull();
    
    while(1){       
        for(i=0; i<NRF52_SAADC::channelCounter; i++){
            voltage[i] = ((float)(diffADCs[i]->read()))*(3.3f/8192);    // Convert raw data into voltage
            sprintf(buffer, "ADC voltage is: %f", voltage[i]);
            epd.writeString(buffer, 30, 50+i*20, 0);
        }
        epd.write();
        for(i=0; i<NRF52_SAADC::channelCounter; i++){
            sprintf(buffer, "ADC voltage is: %f", voltage[i]);
            epd.writeString(buffer, 30, 50+i*20, 1);
        }
        epd.write();
    }
}