/* Copyright (c) 2016 Aconno. All Rights Reserved.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 */


#include "mbed.h"
#include "acd52832_bsp.h"
#include "LSM9DS1_regs.h"
#include "LSM9DS1_defVals.h"
#include "GDEP015OC1.h"

// #define GYRO

SPI spi(p3, NC, p4);
GDEP015OC1 epd = GDEP015OC1(spi, p5, p6, p7, p8);

// Initialize I2C protocol
I2C mems(PIN_EXP_SDA, PIN_EXP_SCL);

DigitalOut RED(PIN_LED_RED);
DigitalOut GREEN(PIN_LED_GREEN);
DigitalOut BLUE(PIN_LED_BLUE);
DigitalOut LEDD(PIN_LED);


void check(bool success)
{
    if(!success) {
        // serial.printf("Success.\n");
        RED = 1;
        GREEN = 0;
    } else {
        // serial.printf("Unsuccess!\n");
        RED = 0;
        GREEN = 1;
        wait(2);
    }
    wait (0.05);
    RED = 1;
    GREEN = 1;
}



void start_mag()
{
    char data[2];
    bool success;

    data[0] = (char)CTRL_REG1_M;          // Target register
    data[1] = (char)0x7C;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);

    data[0] = (char)CTRL_REG2_M;          // Target register
    data[1] = (char)0x60;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);

    data[0] = (char)CTRL_REG3_M;          // Target register
    data[1] = (char)0x00;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);

    data[0] = (char)CTRL_REG4_M;          // Target register
    data[1] = (char)0x0C;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);

    data[0] = (char)CTRL_REG5_M;          // Target register
    data[1] = (char)0x00;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
}

void read_mag(float *results){
    char results_[6];
    float res_final[3];
    char out_x_l_m = OUT_X_L_M;
    
    check (mems.write(TWI_MAG_ADDR, &out_x_l_m, 1, true));
    check (mems.read(TWI_MAG_ADDR, results_, 6, 0));
    res_final[0] = ((results_[1]<<8) | results_[0]);
    res_final[1] = ((results_[3]<<8) | results_[2]);
    res_final[2] = ((results_[5]<<8) | results_[4]);
    
    *(results) = res_final[0];
    *(results + 1) = res_final[1];
    *(results + 2) = res_final[2];
}

void start_acc()
{
    char data[2];
    bool success;
    
    data[0] = (char)CTRL_REG5_XL;          // Target register
    data[1] = (char)0x38;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
    
    data[0] = (char)CTRL_REG6_XL;          // Target register
    data[1] = (char)0xC7;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
    
}

void read_acc(float *results){
    char results_[6];
    float res_final[3];
    char out_x_l_xl = OUT_X_L_XL;
    
    check (mems.write(TWI_MAG_ADDR, &out_x_l_xl, 1, true));
    check (mems.read(TWI_MAG_ADDR, results_, 6, 0));
    res_final[0] = ((results_[1]<<8) | results_[0]);
    res_final[1] = ((results_[3]<<8) | results_[2]);
    res_final[2] = ((results_[5]<<8) | results_[4]);
    
    *(results) = res_final[0];
    *(results + 1) = res_final[1];
    *(results + 2) = res_final[2];
}

void start_gyro(){
    char data[2];
    bool success;
    
    // If GYRO is defines (gyro enabled)
    #ifdef GYRO
        data[0] = (char)CTRL_REG6_XL;                  // Target register
        data[1] = (char)0xC7 & (char)0x1F;             // Data to write
        success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
        check(success);
    #endif
    
    data[0] = (char)CTRL_REG1_G;          // Target register
    data[1] = (char)0xC0;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
    
    data[0] = (char)CTRL_REG2_G;          // Target register
    data[1] = (char)0x00;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
    
    data[0] = (char)CTRL_REG3_G;          // Target register
    data[1] = (char)0x00;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
    
    data[0] = (char)CTRL_REG4;            // Target register
    data[1] = (char)0x3A;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
    
    data[0] = (char)ORIENT_CFG_G;          // Target register
    data[1] = (char)0x00;                 // Data to write
    success = mems.write(TWI_MAG_ADDR, data, 0x02,0);
    check(success);
}

void read_gyro(float *results){
    char results_[6];
    float res_final[3];
    char out_x_l_g = OUT_X_L_G;
    
    check (mems.write(TWI_MAG_ADDR, &out_x_l_g, 1, true));
    check (mems.read(TWI_MAG_ADDR, results_, 6, 0));
    res_final[0] = ((results_[1]<<8) | results_[0]);
    res_final[1] = ((results_[3]<<8) | results_[2]);
    res_final[2] = ((results_[5]<<8) | results_[4]);
    
    *(results) = res_final[0];
    *(results + 1) = res_final[1];
    *(results + 2) = res_final[2];
}


int main()
{
    float old_res = 0;
    float results[3];
    char buffer[6];

    // Clear LEDs
    RED = 1;
    GREEN = 1;
    
    // Start acceleration sensor
    start_acc();

    while (1) {        
        // Get data from mag sensor
        read_acc(results);
        
        if (*results != old_res) {
            // Write new value on display
            epd.empty();
            epd.write();
            
            // Write mag_x
            sprintf(buffer, "%+2.1f", *results);    //Create a string
            epd.writeString(buffer,85,70,0);                                       //Write new data to the buffer
            epd.write();
            
            // Write mag_y
            sprintf(buffer, "%+2.1f", *(results+1));    //Create a string
            epd.writeString(buffer,85,80,0);                                       //Write new data to the buffer
            epd.write();
            
            // Write mag_z
            sprintf(buffer, "%+2.1f", *(results+2));    //Create a string
            epd.writeString(buffer,85,90,0);                                       //Write new data to the buffer
            epd.write();

            old_res = *results;
            BLUE = 0;
            wait (1);
            BLUE = 1;
            wait(1);
        }
        LEDD = 0;
        wait(1);
        LEDD = 1;
        wait(1);
    }


}