/*
 *  
 *
 */
 
#include "main.h"


#if DEBUG_LED
    DigitalOut advLed(p22);
    DigitalOut scanLed(p23);
    DigitalOut periodicLed(p24);
#endif

Thread tBleUpdateData;
Thread tBleStartAdvertising;
Thread tBleStartScanning;
Thread tPeriodicCallback;

int main()
{
    printf("Main program started.\r\n");
    
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);
    printf("BLE initialised.\r\n");
    
    #if DEBUG_LED
        // Turn the leds off
        advLed = 1;
        scanLed = 1;
        periodicLed = 1;
    #endif
       
    tBleUpdateData.start(callback(bleUpdateData, &ble));
    tBleStartAdvertising.start(callback(bleStartAdvertising, &ble));
    tBleStartScanning.start(callback(bleStartScanning, &ble));
    tPeriodicCallback.start(callback(periodicCallback, &ble));
    
    while(true)
    {
        // Do nothing
        
    }
}

