/*
 *
 *
 */
 
#ifndef TASKS_H
#define TASKS_H

#include "mbed.h"
#include "aconno_ble.h"
#include "ble/BLE.h"
#include "GapAdvertisingData.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"

#define DEBUG_LED               (1)
#define PERIODIC_CALLBACK_S     (1)
#define PRINT_ON_RTT            (1)

#define UPDATE_DATA_SIG             (0x00001020)

#if PRINT_ON_RTT
    #include "SEGGER_RTT.h"
    #define printf(...)                      SEGGER_RTT_printf(0, __VA_ARGS__)
#else
    #define printf(...)
#endif

void bleUpdateData(BLE *ble);
void bleStartAdvertising(BLE *ble);
void bleStartScanning(BLE *ble);
void periodicCallback(BLE *ble);

#endif // TASKS_H