/*
 *
 *
 */

#include "tasks.h"
#include "aconno_ble.h"

#if DEBUG_LED
    extern DigitalOut advLed;
    extern DigitalOut scanLed;
    extern DigitalOut periodicLed;
#endif


// BLE global data
GapAdvertisingData adv_data = GapAdvertisingData();
uint16_t adv_cntr = 0;


void periodicCallback(BLE *ble)
{
    while(true)
    {
        ble->waitForEvent();
        #if DEBUG_LED
            periodicLed = !periodicLed;
        #endif
        wait(PERIODIC_CALLBACK_S);
    }       
}

void bleUpdateData(BLE *ble)
{
    while (true)
    {
        Thread::signal_wait(UPDATE_DATA_SIG);
        Thread::signal_clr(UPDATE_DATA_SIG);
        
        while (rssi_buff.cntr != 0)
        {
            memcpy(MSD, uuid, sizeof(uuid));
            memcpy(MSD + sizeof(uuid), &(rssi_buff.pairs[rssi_buff.cntr-1]), sizeof(rssi_buff.pairs[0]));
            
            rssi_buff.cntr--;
            
            adv_data = ble->getAdvertisingData();
            adv_data.updateData(adv_data.MANUFACTURER_SPECIFIC_DATA, (uint8_t*)MSD, MSD_SIZE_b);
            ble->setAdvertisingData(adv_data);
            
            wait_ms(ADV_INTERVAL_MS*2);
        }
    }
}

void bleStartAdvertising(BLE *ble)
{
    while(true)
    {
        //ble->gap().startAdvertising();
        //printf("Advertisement started.\r\n");
        #if DEBUG_LED
            advLed = 0;
        #endif
        wait(ADVERTISING_DURATION_S);
        wait_ms(1000);
        //ble->gap().stopAdvertising();
        //printf("Advertisement stopped.\r\n");
        #if DEBUG_LED
            advLed = 1;
        #endif
        wait(BLE_SLEEP_DURATION_S);
        wait_ms(1000);
    }
}

void bleStartScanning(BLE *ble)
{
    while(true)
    {
        ble->gap().setScanParams(300, 250);
        ble->gap().startScan(advertisementCallback);
        Thread::signal_wait(0x00023456);
        //Thread::signal_clr(ACC_INT_SIG);
        //bleT.signal_set(DISABLE_BLE_SIG);
    }    
}
