/*
*  Made by Jurica Resetar @ aconno
*  More info @ aconno.de
*  jurica_resetar@yahoo.com
*/

#ifndef ACONNO_BLE_H
#define ACONNO_BLE_H

#include "mbed.h"
#include "ble/BLE.h"
#include "GapAdvertisingData.h"

#define UUID_SIZE                   (10)
#define MSD_SIZE_b                  (10+6+1)
#define CONTROL_SIZE                (10)
#define ADV_INTERVAL_MS             (100)
#define ADVERTISING_DURATION_S      (1)
#define BLE_SLEEP_DURATION_S        (1)
#define PRINT_ON_RTT                (1)
#define DEVICE_NAME_ID              (0x09)

#define PER_MOD_CNT                 (4)
#define ADDR_LEN                    (6)

#if PRINT_ON_RTT
    #include "SEGGER_RTT.h"
    #define printf(...)                      SEGGER_RTT_printf(0, __VA_ARGS__)
#else
    #define printf(...)
#endif

typedef struct {
    uint8_t addr[ADDR_LEN];
    int8_t rssi;
} addr_rssi_pair_t;

typedef struct {
    uint8_t cntr;
    addr_rssi_pair_t pairs[PER_MOD_CNT];
} rssi_buff_t;

extern rssi_buff_t rssi_buff;

/* Global variables and constants */
const char uuid[UUID_SIZE] = {0x59, 0x00, 0x22, 0xF1, 0xDA, 0x7A, 0x42, 0xA4, 0xBB, 0xDF};
extern char MSD[MSD_SIZE_b];
const char CONTROL[CONTROL_SIZE] = {0x59, 0x00, 0x9C, 0x23, 0x9D, 0x82, 0x1B, 0xD4, 0x11, 0xE8};

/* Function declarations */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params);
void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params);

#endif //ACONNO_BLE_H