/*
 *   Made by Jurica Resetar @ aconno
 *   More info @ aconno.de
 *
 */

#include "main.h"
#include "tasks.h"
#include "aconno_ble.h"


char MSD[MSD_SIZE_b];
rssi_buff_t rssi_buff;

/**
* Callback triggered when the ble initialization process has finished
*/
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params){
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
    
    // Setup rssi_buff
    rssi_buff.cntr = 0;
    
    /* setup advertising */
    //ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)MSD, MSD_SIZE_b);
    ble.gap().setAdvertisingInterval(ADV_INTERVAL_MS);
    ble.gap().startAdvertising();
}

/* advertisement callback is called every time a new ble device is discovered */
void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params){
    
    bool is_valid_device = false;
    
    uint8_t payloadSize;
    const uint8_t *payload;
    uint8_t dataSize=0, dataType=0, tempIndex=0;
    
    payloadSize = params->advertisingDataLen;
    payload = params->advertisingData;
    dataSize = *(payload);
    dataType = *(payload+1);
    
    do{
        if(dataType == DEVICE_NAME_ID){
            printf("Device name:\t");
            for(int i=tempIndex; i<tempIndex+dataSize-1; i++){
                printf("%c", (char)*(payload+tempIndex+i+2));
                /*
                if(*(MeriddaDeviceName+i) == *(payload+tempIndex+i+2))
                {
                    tryToConnect = 1;
                    SEND("Meridda device discovered\r\n");
                }
                */
            }
            printf("\r\n");
            printf("RSSI: %d\r\n", params->rssi);
            
            dataType = 0;
        }
        else if (dataType == GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA){
            
            if (!memcmp((uint8_t*)(payload+tempIndex+2), (uint8_t*)CONTROL, CONTROL_SIZE))
                is_valid_device = true;
            
            dataType = 0;
        }
        else{
            tempIndex = tempIndex + dataSize + 1;
            dataSize = *(payload+tempIndex);
            dataType = *(payload+tempIndex+1);
        }
    }while(tempIndex<payloadSize && !is_valid_device);
    
    
    if (is_valid_device){
        
        bool is_present = false;
        uint8_t *tmp = (uint8_t*)(params->peerAddr);
        
        // Check if MAC is already pressent in pairs array. If it is don't add
        // it, just update rssi value.
        for (int i = 0; i < rssi_buff.cntr; i++)
            if (!memcmp(rssi_buff.pairs[i].addr, (params->peerAddr), ADDR_LEN)){
                rssi_buff.pairs[i].rssi = params->rssi;
                is_present = true;
            }
        
        if (!is_present && (rssi_buff.cntr < PER_MOD_CNT)){
            memcpy(rssi_buff.pairs[rssi_buff.cntr].addr, (params->peerAddr), ADDR_LEN);
            rssi_buff.pairs[rssi_buff.cntr++].rssi = params->rssi;
            tBleUpdateData.signal_set(UPDATE_DATA_SIG);
            printf("%X %X %X %X %X %X\n", tmp[5], tmp[4], tmp[3], tmp[2], tmp[1], tmp[0]);
        }
    }
    
    /*
    if(tryToConnect){
        SEND("Trying to establise connection...\r\n");
        BLE::Instance().gap().connect(params->peerAddr, Gap::ADDR_TYPE_RANDOM_STATIC, NULL, NULL);
    }
    */
}