/* Copyright (c) 2016 Aconno. All Rights Reserved.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 *   aconno simple example program
 *   IR LED sends "SOS" in the world
 */
 
 
#include "mbed.h"
#include "acd52832_bsp.h"

#define DOT_LENGTH 0.5                      // Dot length (duration) in seconds
#define DASH_LENGTH (DOT_LENGTH * 3)         // Dash length (duration)
#define ELEMENTS_PAUSE (DOT_LENGTH)          // Pause between elements
#define CHARS_PAUSE (DOT_LENGTH * 3)    // Pause between characters
#define WORDS_PAUSE (DOT_LENGTH *7)          // Pause between words

#define ON 1
#define OFF 0


DigitalOut IrLED(PIN_IRLED);

void dot(DigitalOut LED){
    // Turn IR LED ON
    LED = ON;
    wait(DOT_LENGTH);
    // Turn it off
    LED = OFF;
    wait(ELEMENTS_PAUSE);
    }

void dash(DigitalOut LED){
    // Turn IR LED ON
    LED = ON;
    wait(DASH_LENGTH);
    // Turn it off
    LED = OFF;
    wait(ELEMENTS_PAUSE);
}

void S_code(DigitalOut LED){
    dot(LED);
    dot(LED);
    dot(LED);
}

void O_code(DigitalOut LED){
    dash(LED);
    dash(LED);
    dash(LED);
}


int main(){
    while(1){
        S_code(IrLED);
        wait(CHARS_PAUSE);
        O_code(IrLED);
        wait(CHARS_PAUSE);
        S_code(IrLED);
        wait(WORDS_PAUSE);
    }
}