/*
 * Made by Jurica @ aconno
 * jurica_resetar@yahoo.com
 *
*/

#include <stdio.h>
#include "mbed.h"
#include "Si7006A20.h"
#include "nrf52_digital.h"

#define DEBUG_PRINT     (1)

#if DEBUG_PRINT
    #include "nrf52_uart.h"
    #define TX_PIN_NUMBER p25
    #define RX_PIN_NUMBER p26
    NRF52_UART serial(TX_PIN_NUMBER, RX_PIN_NUMBER, Baud9600);
    char buffer[255]={0};
    #define SEND(...) {uint8_t len = sprintf(buffer, __VA_ARGS__); serial.send(buffer, len);}
#else
    #define SEND(...);
#endif

Si7006 si(p19, p20);
NRF52_DigitalOut power(p2);

int main(){    
    float temperature;  
    float humidity;
    
    SEND("Main started.\r\n");
    power = 1;
    SEND("Main power activated.\r\n");
    
    while(1){
        humidity = si.getHumidity();
        SEND("Humidity is: %f%%\r\n", humidity);
        temperature = si.getTemperature();
        SEND("Temperature is: %fC\r\n", temperature);
        wait(1);
    }
}