/*
 *  Something nice =)
 *  Jurica Resetar @ aconno.de
 *
 */

#include "mbed.h"
#include "bmc150.h"
#include "acd52832_bsp.h"
#include "utilities.h"

#define SPI_MISO        (p17)
#define SPI_MOSI        (p18)
#define SPI_CLK         (p20)
#define BMC150_SPI_CS   (p19)

#define VCC_ON_PIN      (p25)

DigitalOut bmcCs(BMC150_SPI_CS);
DigitalOut vccOn(VCC_ON_PIN);
DigitalOut readyLED(PIN_LED_RED);
SPI spi(SPI_MOSI, SPI_MISO, SPI_CLK); // mosi, miso, sclk
BMC150 bmc(spi, bmcCs);

int main(){
    uint8_t temperature;
    readyLED = 0;
    vccOn = 1; // Turn VCC_ON on for BMC150
    wait_ms(100);
    readyLED = 1;
    
    temperature = bmc.readTemperature();
    
}
