/*******************************************************************************
 * Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 *
 *******************************************************************************
 */

 /*
 * The library is modified to suite Si7006A20 Humidity and Temperature Sensor
 * by Jurica Resetar @ aconno
 * More info and contact: aconno.de
 * jurica_resetar@yahoo.com
 *
 */

#include "Si7006A20.h"
#include "aconno_i2c.h"

#define TEMPERATURE_DELAY_MS   (10)
#define HUMIDITY_DELAY_MS   (20)

char cmd_meas_humid = 0xE5;
char cmd_meas_humid_no_hold = 0xF5;
char cmd_meas_temp = 0xE3;
char cmd_meas_temp_no_hold = 0xF3;
char cmd_meas_prev_temp = 0xE0;
char cmd_rst = 0xFE;
char cmd_write_user1 = 0xE6;
char cmd_read_user1 = 0xE7;
char cmd_id_1[] = {0xFA, 0x0F};
char cmd_id_2[] = {0xFC, 0xC9};
char cmd_fw_ver[] = {0x84, 0xB8};


Si7006::Si7006(I2C *i2c) : i2c(i2c, char(I2C_ADDR)){
    
}

uint8_t Si7006::getElectronicId(char* id){
    uint8_t success;
    
    success = i2c.sendCommand(cmd_id_1, sizeof(cmd_id_1), id, 4);
    success = i2c.sendCommand(cmd_id_2, sizeof(cmd_id_2), (id+4), 4);
    
    return success;
}

int Si7006::configResolution(Si7006::resolution_t resolution){
    char data;
    
    // Read User1 Register
    i2c.readFromReg(cmd_read_user1, &data, 1);
    switch (resolution) {
        case RH_12b_TEMP_14b:
            data &= ~0x81;
            break;
        case RH_8b_TEMP_12b:
            data = (data & ~0x80) | 0x01;
            break;
        case RH_10b_TEMP_13b:
            data = (data & ~0x01) | 0x80;
            break;
        case RH_11b_TEMP_11b:
            data |= 0x81;
            break;
        default:
            return -1;
    }

    return i2c.writeToReg(cmd_write_user1, &data, 1);    
}

float Si7006::getTemperature(){
    char temper[2];
    
    i2c.sendCommand(&cmd_meas_temp_no_hold, sizeof(cmd_meas_temp_no_hold));
    wait_ms(TEMPERATURE_DELAY_MS);
    i2c.readBus(temper, 2);

    return calculateTemperature(temper);
}

float Si7006::calculateTemperature(char *rawTemp){
    float temperature;
    int16_t code;
    
    code = (uint16_t)((*(rawTemp+0)<<8) + (*(rawTemp+1)<<0));
    temperature = (((float)175.72 * code) / 65536.0f) - 46.85;
    
    //return temperature;
    return temperature;
}

float Si7006::getHumidity(){
    char humid[2];
    
    i2c.sendCommand(&cmd_meas_humid, sizeof(cmd_meas_humid));
    wait_ms(HUMIDITY_DELAY_MS);
    i2c.readBus(humid, 2);
    
    return checkHumidity(humid);
}

float Si7006::checkHumidity(char *rawHumidity){
    float humidity;
    uint16_t code;

    // Get 16-bit value from bytes read
    code = (uint16_t)((*(rawHumidity+0)<<8) + (*(rawHumidity+1)<<0));
    // Calculate the humidity using the formula from the datasheet
    humidity = ((((float)125 * code)) / 65536.0f) - 6;

    return humidity;
}

int Si7006::getPrevTemperature(float *tempC) {
    /*
    if (i2c.write(i2cADDR, cmd_meas_prev_temp, sizeof(cmd_meas_prev_temp)) != 0) {
        return -1;
    }
    if(checkTemperature(tempC) != 0) {
        return -1;
    }
    return 0;
    */
}

int Si7006::getPrevTemperature(int16_t *tempCx10) {
    /*
    if (i2c.write(i2cADDR, cmd_meas_prev_temp, sizeof(cmd_meas_prev_temp)) != 0) {
        return -1;
    }
    if(checkTemperature(tempCx10) != 0) {
        return -1;
    }
    return 0;
    */
}

int Si7006::getRev(char *rev){
    /*
    if (i2c.write(i2cADDR, cmd_fw_ver, sizeof(cmd_fw_ver)) != 0) {
        return -1;
    }
    if (i2c.read(i2cADDR, rev, 1) != 0) {
        return -1;
    }
    
    return 0;
    */
}

int Si7006::heater(bool enable){
    char data[2];
    /*
    if (i2c.write(i2cADDR, cmd_read_user1, sizeof(cmd_read_user1)) != 0) {
        return -1;
    }

    if (i2c.read(i2cADDR, &data[1], 1) != 0) {
        return -1;
    }

    if (enable) {
        data[1] |= 0x04;
    } else {
        data[1] &= ~0x04;
    }

    data[0] = cmd_write_user1[0];

    if (i2c.write(i2cADDR, data, 2) != 0) {
        return -1;
    }

    return 0;
    */
}

char Si7006::crc8(char value, char seed){
    int i;

    for (i = 0; i < 8; i++) {

        if ((value ^ seed) & 0x80) {
            seed <<= 1;
            seed ^= POLYVAL;
        } else {
            seed <<= 1;
        }
        value <<= 1;
    }
    return seed;
}
