/*
 * Library for mma8452 3-Axis, 12-bit/8-bit, Digital Accelerometer
 * Made by Jurica Resetar
 * jurica_resetar@yahoo.com
 *
 * All rights reserved
 */
 
#include "mbed.h"
 
#define SA0 1
#if SA0
    #define MMA8452_ADDRESS     (0x1D << 1)    // SA0 is high, 0x1C if low. Shifting address by 1 bit as i2c is a 7 bit encoding, and this is 8bit encoded
#else
    #define MMA8452_ADDRESS     (0x1C << 1)    // SA0 is high, 0x1C if low. Shifting address by 1 bit as i2c is a 7 bit encoding, and this is 8bit encoded
#endif

#define STATUS 0x00                         // Type 'read' : Real time status, should return 0x00
#define OUT_X_MSB 0x01                      // Type 'read' : x axis - 8 most significatn bit of a 12 bit sample
#define OUT_X_LSB 0x02                      // Type 'read' : x axis - 4 least significatn bit of a 12 bit sample
#define OUT_Y_MSB 0x03                      // Type 'read' : y axis - 8 most significatn bit of a 12 bit sample
#define OUT_Y_LSB 0x04                      // Type 'read' : y axis - 4 least significatn bit of a 12 bit sample
#define OUT_Z_MSB 0x05                      // Type 'read' : z axis - 8 most significatn bit of a 12 bit sample
#define OUT_Z_LSB 0x06                      // Type 'read' : z axis - 4 least significatn bit of a 12 bit sample

#define SYSMOD 0x0B                         // Type 'read' : This tells you if device is active, sleep or standy 0x00=STANDBY 0x01=WAKE 0x02=SLEEP
#define WHO_AM_I 0x0D                       // Type 'read' : This should return the device id of 0x2A

#define PL_STATUS 0x10                      // Type 'read' : This shows portrait landscape mode orientation
#define PL_CFG 0x11                         // Type 'read/write' : This allows portrait landscape configuration
#define PL_COUNT 0x12                       // Type 'read' : This is the portraint landscape debounce counter
#define PL_BF_ZCOMP 0x13                    // Type 'read' :
#define PL_THS_REG 0x14                     // Type 'read' :

#define FF_MT_CFG 0X15                      // Type 'read/write' : Freefaul motion functional block configuration
#define FF_MT_SRC 0X16                      // Type 'read' : Freefaul motion event source register
#define FF_MT_THS 0X17                      // Type 'read' : Freefaul motion threshold register
#define FF_COUNT  0X18                       // Type 'read' : Freefaul motion debouce counter

#define ASLP_COUNT 0x29                     // Type 'read/write' : Counter settings for auto sleep
#define CTRL_REG_1 0x2A                     // Type 'read/write' :
#define CTRL_REG_2 0x2B                     // Type 'read/write' :
#define CTRL_REG_3 0x2C                     // Type 'read/write' :
#define CTRL_REG_4 0x2D                     // Type 'read/write' :
#define CTRL_REG_5 0x2E                     // Type 'read/write' :

// Defined in table 13 of the Freescale PDF
#define STANDBY 0x00                        // State value returned after a SYSMOD request, it can be in state STANDBY, WAKE or SLEEP
#define WAKE 0x01                           // State value returned after a SYSMOD request, it can be in state STANDBY, WAKE or SLEEP
#define SLEEP 0x02                          // State value returned after a SYSMOD request, it can be in state STANDBY, WAKE or SLEEP
#define ACTIVE 0x01                         // Stage value returned and set in Control Register 1, it can be STANDBY=00, or ACTIVE=01


 
#define TILT_STATUS 0x03        // Tilt Status (Read only)
#define SRST_STATUS 0x04        // Sample Rate Status Register (Read only)
#define SPCNT_STATUS 0x05       // Sleep Count Register (Read/Write)
#define INTSU_STATUS 0x06       // Interrupt Setup Register
#define MODE_STATUS 0x07        // Mode Register (Read/Write)
#define SR_STATUS 0x08          // Auto-Wake and Active Mode Portrait/Landscape Samples per Seconds Register (Read/Write)
#define PDET_STATUS 0x09        // Tap/Pulse Detection Register (Read/Write)
#define PD_STATUS 0xA           // Tap/Pulse Debounce Count Register (Read/Write)


class Acc_MMA8452{
    public:
        Acc_MMA8452(PinName sda, PinName scl, char address);
        ~Acc_MMA8452();
        //uint8_tinit();
        uint8_t set_register(char reg, char data);
        uint8_t get_register(char reg, char *data);
        uint8_t get_x_acc(char *data);
        uint8_t get_y_acc(char *data);
        uint8_t get_z_acc(char *data);
        
        char acc_address;
        
    private:
    I2C i2c;
};
    