/*
 * Library for mma8452 3-Axis, 12-bit/8-bit, Digital Accelerometer
 * Made by Jurica Resetar
 * jurica_resetar@yahoo.com
 *
 * All rights reserved
 */
 
 
#include "mma8452.h"

Acc_MMA8452::Acc_MMA8452(PinName sda, PinName scl, char address): i2c(sda, scl), acc_address(address){
}

Acc_MMA8452::~Acc_MMA8452(){
}

uint8_t Acc_MMA8452::set_register(char reg, char data){
    char cmd[2] = {0, 0};
    i2c.start();
    cmd[0] = MODE_STATUS;
    cmd[1] = 0x00;                      // Standby Mode on
    i2c.write(acc_address, cmd, 2);
  
    cmd[0] = reg;
    cmd[1] = data;                      // New value of the register
    i2c.write(acc_address, cmd, 2); 
      
    cmd[0] = MODE_STATUS;
    cmd[1] = 0x01;                      // Active Mode on
    i2c.write(acc_address, cmd, 2);
    i2c.stop();
    return 0;       // Success
}

uint8_t Acc_MMA8452::get_register(char reg, char *data){
    char temp_read = 2;
    i2c.start();
    if(i2c.write(acc_address & 0xFE) == 0){            // just good practice to force bit 1 to a '0' by ANDing with 0xFE
        return 1;                                       // we failed to write the mcu address on the bus to initiate dialogue 
    }
    if(i2c.write(reg) == 0){
        return 1;                                       // we failed to write 'who am i' to the chip
    }
    i2c.start();
    if(i2c.write(acc_address | 0x01) == 0){           // this is asking to read the slave mcu address - even though it's a 'write' method!!! Crap API...
        return 1;                                       // we failed to request a read from that mcu - this really is just writing the mcu vaule on the bus
    }
    temp_read = i2c.read(0);
    i2c.stop();
    *data = temp_read;
        
    return 0;       // Success
}

uint8_t Acc_MMA8452::get_x_acc(char *data){
    get_register(OUT_X_MSB, data);
    return 0;
}
uint8_t Acc_MMA8452::get_y_acc(char *data){
    get_register(OUT_Y_MSB, data);
    return 0;
}
uint8_t Acc_MMA8452::get_z_acc(char *data){
    get_register(OUT_Z_MSB, data);
    return 0;
}