/*
 * Made by Jurica Resetar @ Meridda
 * 2017.
 *  
 * All rights reserved
 *
 */
 
#ifndef MAX30101_REGS_H
#define MAX30101_REGS_H

/* I2C adresses */
#define MAX_I2C_ADDRESS     (0xAE)

/* Registers */
/* Status */
#define INT_STATUS_1_REG    (0x00)
#define INT_STATUS_2_REG    (0x01)
#define INT_ENABLE_1_REG    (0x02)
#define INT_ENABLE_2_REG    (0x03)
#define FIFO_WRITE_PTR_REG  (0x04)
#define OVERFLOW_CNTR_REG   (0x05)
#define FIFO_READ_PTR_REG   (0x06)
#define FIFO_DATA_REG_REG   (0x07)
/* Configuration */
#define FIFO_CONFIG_REG     (0x08)
#define MODE_CONFIG_REG     (0x09)
#define SP02_CONFIG_REG     (0x0A)
#define LED1_PA             (0x0C)
#define LED2_PA             (0x0D)
#define LED3_PA             (0x0E)
#define PILOT_PA            (0x10)
#define M_LED_M_CTRL_REG_1  (0x11)
#define M_LED_M_CTRL_REG_2  (0x12)
/* Die temperature */
#define DIE_TEMP_INT_REG    (0x1F)
#define DIE_TEMP_FRAC_REG   (0x20)
#define DIE_TEMP_CONFIG     (0x21)
/* Proximity function */
#define PROX_INT_TH_REG     (0x30)
/* Part ID */
#define REVISION_ID_REG     (0xFE)
#define PART_ID_REG         (0xFF)
 

enum SamplesPerSecond{
    SpS50 = 0,
    SpS100,
    SpS200,
    SpS400,
    SpS800,
    SpS1000,
    SpS1600,
    SpS3200,
};
 
union mode_u{
    uint8_t all;
    struct mode_s{
        uint8_t mode: 3;
        uint8_t reserved: 3;
        uint8_t reset: 1;
        uint8_t shdn: 1;
    }bits;
}; 

 
#endif // MAX30101_REGS_H



