/*
 * Made by Jurica Resetar @ Meridda
 * 2017.
 *  
 * All rights reserved
 *
 */
 
#ifndef MAX30101_H
#define MAX30101_H
 
#include "mbed.h"
#include "max30101_regs.h"
#include "nrf52_digital.h"
 
class MAX30101{
    public:
        MAX30101(I2C *i2c, PinName enablePin);
        char readID();
        inline void enable(){_enable = 1;};
        inline void disable(){_enable = 0;};
        uint8_t writeToReg(char regAddress, char *data, int len);
        uint8_t readFromReg(char regAddress, char *dataBuffer, int len);
        float getTemperature();
        uint8_t configFifo(char *data);
        uint8_t getNumOfSamples();
        uint32_t readFifoSample(char readAddres);
        uint8_t readFifo(int *data, int numOfSamples);
        uint8_t setSamplesPerSecond(SamplesPerSecond samplesPerSecond);
        void setupRedLED(uint8_t pulseInterval);
        void turnGreenLED();
       
    private:
        I2C *i2c;
        uint8_t i2cAddress;
        DigitalOut _enable;
};
 
#endif  //MAX30101_H
