/*
 *   Made by Jurica Resetar @ aconno
 *   More info @ aconno.de
 *
 */

#include "main.h"
#include "aconno_ble.h"
#include "tasks.h"
#include "lizzy_service.h"
#include "proj_config.h"


/* BLE event queue size */
#define BLE_EVENT_COUNT         (4)

init_lizzy_t init_lizzy = {
    .buzz = false,
    .leds = {false ,false, false},
    .acc_lsb = LSB_VALUE,
    .acc_data = {0, 0, 0}
};
LizzyService *lizzy_service;

static bool clientConected = false;
static EventQueue eventQueue( BLE_EVENT_COUNT * EVENTS_EVENT_SIZE );


void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context)
{
    BLE &ble = context->ble;
    eventQueue.call(Callback<void()>(&ble, &BLE::processEvents));
}

EventQueue *getBLEEventQueue(void)
{
    return &eventQueue;
}

bool bleIsClientConnected(void)
{
    return clientConected;
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    clientConected = false;
    (lizzy_service->get_ble())->gap().startAdvertising();
}

void onConnectionCallback(const Gap::ConnectionCallbackParams_t *params){   
    clientConected = true;
}

void onDataWrittenCallback(const GattWriteCallbackParams *params) 
{
    if ((params->handle == lizzy_service->getBuzzHandle()))
    {
#if VODAFONE_COMPATIBILITY == 1
#else
        if ((uint8_t)true < *(params->data))
            lizzy_service->setBuzz(true);
#endif
        updateBuzzLedsT.signal_set(UPDATE_BUZZ_LEDS);
    }
#if VODAFONE_COMPATIBILITY == 1
#else
    else if ((params->handle == lizzy_service->getRedLedHandle()) &&
        (params->len == 1))
    {
        if ((uint8_t)true < *(params->data))
            lizzy_service->setRedLed(true);
            
        updateBuzzLedsT.signal_set(UPDATE_BUZZ_LEDS);
    }
#endif
    else if ((params->handle == lizzy_service->get_green_handle()) &&
        (params->len == 1))
    {
        if ((uint8_t)true < *(params->data))
            lizzy_service->set_green_state(true);
            
        updateBuzzLedsT.signal_set(UPDATE_BUZZ_LEDS);
    }
    else if ((params->handle == lizzy_service->get_blue_handle()) &&
        (params->len == 1))
    {
        if ((uint8_t)true < *(params->data))
            lizzy_service->set_blue_state(true);
            
        updateBuzzLedsT.signal_set(UPDATE_BUZZ_LEDS);
    }
}


/**
* Callback triggered when the ble initialization process has finished
*/

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    advertising_packet advertisementPacket;
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        return;
    }

    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
    
    lizzy_service = new LizzyService(ble, &init_lizzy);
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gap().onConnection(onConnectionCallback);         
    ble.gattServer().onDataWritten(onDataWrittenCallback);
    
#if VODAFONE_COMPATIBILITY == 1
    uint8_t myMacAddress[6];
    BLEProtocol::AddressType_t temp_address_type;
    ble.gap().getAddress(&temp_address_type, myMacAddress);
    lizzy_service->setMac(myMacAddress);    // Update MAC address
#endif
    
    // Setup event handling. This is needed only with services.
    ble.onEventsToProcess(scheduleBleEventsProcessing);
    
    advertisementPacket.header = APPLICATION_ID;
    advertisementPacket.type = 0x00;
    advertisementPacket.gyroscope[0] = (int16_t)0;
    advertisementPacket.gyroscope[1] = (int16_t)0;
    advertisementPacket.gyroscope[2] = (int16_t)0;
    advertisementPacket.accelerometer[0] = (int16_t)0;
    advertisementPacket.accelerometer[1] = (int16_t)0;
    advertisementPacket.accelerometer[2] = (int16_t)0;
    advertisementPacket.magnetometer[0] = (int16_t)0;
    advertisementPacket.magnetometer[1] = (int16_t)0;
    advertisementPacket.magnetometer[2] = (int16_t)0;
    
    /* setup advertising */
#if VODAFONE_COMPATIBILITY == 1
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::INCOMPLETE_LIST_128BIT_SERVICE_IDS  , (uint8_t*)UUID, sizeof(UUID));
#else
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&advertisementPacket, sizeof(advertisementPacket));
#endif
    ble.gap().setAdvertisingInterval(ADV_INTERVAL_MS);
    //ble.gap().startAdvertising();
}

void updatePayload(BLE *ble, advertising_packet *advertisementPacket)
{
    ble->gap().stopAdvertising();
    GapAdvertisingData advetisementData = GapAdvertisingData();
    advetisementData = ble->getAdvertisingData();
    advetisementData.updateData(advetisementData.MANUFACTURER_SPECIFIC_DATA, (uint8_t *)advertisementPacket, sizeof(advertising_packet));
    ble->setAdvertisingData(advetisementData);
    //ble->gap().startAdvertising();
}
