#include "main.h"
#include "bsp.h"
#include "bsp_buzz.h"
#include "bsp_led.h"
#include "aconno_ble.h"
#include "tasks.h"
#include "GapAdvertisingData.h"


DigitalOut redLed(RED_LED_PIN);
#if NANO_MODULE == 0
DigitalOut greenLed(GREEN_LED_PIN);
DigitalOut blueLed(BLUE_LED_PIN);
#endif

extern Lis2dh12 mems;
extern InterruptIn INT1;

Buzz buzzer(NRF_PWM2, BUZZER_PIN);

static advertising_packet advertisementPacket;
static GapAdvertisingData adv_data = GapAdvertisingData();


#if TEST_LEDS_BUZZ
Ticker test_ticker;
#endif

LowPowerTicker longDelaysT;


inline void startLongDelay(uint32_t delay)
{
    longDelaysT.attach(longDelaysC, delay);
}

inline void stopLongDelay()
{
    longDelaysT.detach();
}


void tasks_init()
{
    redLed = 1;
    greenLed = 1;
    blueLed = 1;
    
#if TEST_LEDS_BUZZ
    test_ticker.attach(led_tick, 0.5);
#endif
}

#if TEST_LEDS_BUZZ
void buzz_tick()
{
    static int start = 1;
    
    if (start)
    {
        buzzer.enable();
        start = 0;
    }
    else
    {
        buzzer.disable();
        start = 1;
        led_tick();
        test_ticker.detach();
        test_ticker.attach(led_tick, 0.5);
    }
}

void led_tick()
{
    static int count = 0;
    
    switch(count)
    {
        case 0:
            redLed = 0;
            break;
            
        case 1:
            redLed = 1;
            greenLed = 0;
            break;
            
        case 2:
            greenLed = 1;
            blueLed = 0;
            break;
        
        default:
            blueLed = 1;
            count = -1;
            buzz_tick();
            test_ticker.detach();
            test_ticker.attach(buzz_tick, BUZZ_TIME_S);
    }
    
    count++;
}
#endif

void measureF(Lis2dh12 *mems)
{
    int untilSleep;
    
    while(1)
    {
        Thread::signal_wait(START_MEAS);
        Thread::signal_clr(START_MEAS);
        
        INT1.disable_irq();
        
        untilSleep = ACTIVE_PERIOD_MS / MEASURE_INTERVAL_MS;
        
        BLE::Instance().startAdvertising();
        
        while (1)
        {
            advertisementPacket.header = APPLICATION_ID;
            advertisementPacket.type = 0x00;
            advertisementPacket.gyroscope[0] = (int16_t)0;
            advertisementPacket.gyroscope[1] = (int16_t)0;
            advertisementPacket.gyroscope[2] = (int16_t)0;
            advertisementPacket.magnetometer[0] = (int16_t)0;
            advertisementPacket.magnetometer[1] = (int16_t)0;
            advertisementPacket.magnetometer[2] = (int16_t)0;
            
#if NORMAL_AXIS == 1
            advertisementPacket.accelerometer[0] = (int16_t)mems->readXAxis();
            advertisementPacket.accelerometer[1] = (int16_t)mems->readYAxis();
            advertisementPacket.accelerometer[2] = (int16_t)mems->readZAxis();
#else
            advertisementPacket.accelerometer[0] = -(int16_t)mems->readYAxis();
            advertisementPacket.accelerometer[1] = (int16_t)mems->readXAxis();
            advertisementPacket.accelerometer[2] = (int16_t)mems->readZAxis();
#endif
            advertisementPacket.accelerometer[0] *= 60; 
            advertisementPacket.accelerometer[1] *= 60;
            advertisementPacket.accelerometer[2] *= 60;
            
            printf("X: %d", advertisementPacket.accelerometer[0]);
            printf("\tY: %d", advertisementPacket.accelerometer[1]);
            printf("\tZ: %d\n", advertisementPacket.accelerometer[2]);

            advertisementPacket.acc_lsb_value = LSB_VALUE;
            
            updateServiceT.signal_set(MEAS_DONE);
            bleT.signal_set(MEAS_DONE);
            
            wait_ms(MEASURE_INTERVAL_MS);
            untilSleep--;
            
            if( (untilSleep <= 0) && !bleIsClientConnected() )
            {
                BLE::Instance().stopAdvertising();
                startLongDelay(LONG_SLEEP_S);
                break;
            }
        }
    }
}

void updateServiceF()
{
    while (1)
    {
        Thread::signal_wait(MEAS_DONE);
        updateServiceT.signal_clr(MEAS_DONE);
        
        lizzy_service->set_acc_data(advertisementPacket.accelerometer);
    }
}

void updateBuzzLedsF()
{
#if VODAFONE_COMPATIBILITY == 1
    const uint8_t startBuzz = 0xBA;
#endif    
    
    while (1)
    {
        Thread::signal_wait(UPDATE_BUZZ_LEDS);
        updateBuzzLedsT.signal_clr(UPDATE_BUZZ_LEDS);

#if VODAFONE_COMPATIBILITY == 1
        uint8_t tmpBuzzState[4];
        if( buzzer.get_state() != 
            (lizzy_service->getBuzz(tmpBuzzState)[0] == startBuzz) )
#else
        if( buzzer.get_state() != (lizzy_service->getBuzz()) )
#endif
        {
#if VODAFONE_COMPATIBILITY == 1
            if( tmpBuzzState[0] == startBuzz )
#else
            if( lizzy_service->getBuzz() )
#endif
                buzzer.enable();
            else
                buzzer.disable();
        }
#if VODAFONE_COMPATIBILITY == 1
#else
        if( !redLed != (lizzy_service->getRedLed()) )
        {
            redLed = !(lizzy_service->getRedLed());
        }
#endif
        if( !greenLed != (lizzy_service->get_green_state()) )
        {
            greenLed = !(lizzy_service->get_green_state());
        }
        if( !blueLed != (lizzy_service->get_blue_state()) )
        {
            blueLed = !(lizzy_service->get_blue_state());
        }
    }
}

void bleF(BLE *ble)
{
    while(true)
    {
        Thread::signal_wait(MEAS_DONE);
        bleT.signal_clr(MEAS_DONE);

#if VODAFONE_COMPATIBILITY == 1
#else
        adv_data = ble->getAdvertisingData();
        adv_data.updateData(adv_data.MANUFACTURER_SPECIFIC_DATA, (uint8_t *)&advertisementPacket, sizeof(advertisementPacket));
        ble->setAdvertisingData(adv_data);
#endif

    }
}

void servLoopC(void)
{
    while(1)
    {
        getBLEEventQueue()->dispatch_forever();
        Thread::wait(0xFFFFFFFF);
    }
}

void longDelaysC(void)
{
    mems.clearIntFlag();
    
    INT1.enable_irq();
    
    stopLongDelay();
}