/* 
 * aconno.de
 * Made by Jurica Resetar
 * All right reserved 
 *
 */

#include "main.h"
#include "bsp.h"
#include "tasks.h"


char memsI2CAddress = I2C_ADDRESS;
Thread bleT;
Thread measureT;
Thread updateServiceT;
Thread updateBuzzLedsT;
Thread servLoopT;


extern DigitalOut redLed;
DigitalOut AccVcc(ACC_POWER_PIN);
InterruptIn INT1(INT_PIN1);
//InterruptIn INT2(INT_PIN2);
I2C i2c(I2C_DATA,I2C_CLK);

Lis2dh12 mems(&i2c, memsI2CAddress);


void int1Handler(void)
{
    __disable_irq();
    
    mems.clearIntFlag();
    //redLed = !redLed;
    
    measureT.signal_set(START_MEAS);
    
    __enable_irq();
}

int main(){
    
    tasks_init();
    
    printf("Main program started.\r\n");
    
    NRF_NVMC->CONFIG = 0x00000002;      // Erase enable UICR
    NRF_NVMC->ERASEUICR = 0x00000001;   // Erase all
    NRF_NVMC->CONFIG = 0x00000001;      // Write enable UICR
    NRF_UICR->NFCPINS = 0xFFFFFFFE;     // Change NFC to GPIO function
    

    AccVcc = 1;
    wait_ms(POWER_UP_DELAY_MS);

    //measureT.signal_set(START_MEAS);
    INT1.rise(int1Handler);
    NRF_GPIO->PIN_CNF[INT_PIN1] &= 0xFFFFFFF3;  // NO PullUps
    
    BLE &ble = BLE::Instance();
    ble.init(bleInitComplete);

    mems.setMode(LOW_POWER);
    //mems.setMode(HIGH_RES);
    mems.enableAxes(X_axis);
    mems.enableAxes(Y_axis);
    mems.enableAxes(Z_axis);    
    mems.setODR(ACC_ODR_MODE);
    //mems.setScale(_16g);
    mems.setScale(_8g);
    mems.int1Setup(0x40);       // IntActivity 1 driven to INT1 pad
    mems.int1Latch(0x01);       // Enable int1 latch
    mems.int1Threshold(INT1_THRESHOLD); 
    mems.int1Duration(INT1_DUR);            
    mems.int1Config(0x2A);      // Enable XHigh, YHigh and ZHigh

    bleT.start(callback(bleF, &ble));   // Start bleT
    measureT.start(callback(measureF, &mems));
    updateServiceT.start(updateServiceF);
    updateBuzzLedsT.start(updateBuzzLedsF);
    servLoopT.start(servLoopC);
    
    while(1){
        //disableI2C();
        //ble.waitForEvent();
        Thread::wait(0xFFFFFFFF);
    }
}
