#ifndef __LIZZY_SERVICE_H__
#define __LIZZY_SERVICE_H__

#include "mbed.h"
#include "ble/BLE.h"
#include "service_macros.h"
#include "proj_config.h"

#define NUM_LEDS        (3)
#define NUM_AXIS        (3)


typedef struct
{
    bool buzz;
    bool leds[NUM_LEDS];
    uint16_t acc_lsb;
    int16_t acc_data[NUM_AXIS];
} init_lizzy_t;


class LizzyService{
    public:
        const static uint16_t LIZZY_SERVICE_UUID = 0xA000;
        const static uint16_t BUZZ_UUID = 0xA001;
        const static uint16_t MAC_RED_UUID = 0xA002;
        const static uint16_t GREEN_UUID = 0xA003;
        const static uint16_t BLUE_UUID = 0xA004;
        const static uint16_t ACC_LSB_UUID = 0xA005;
        const static uint16_t ACC_DATA_UUID = 0xA006;

        LizzyService(BLEDevice &_ble, init_lizzy_t *init) :
              ble(_ble),
#if VODAFONE_COMPATIBILITY == 1
              buzz(BUZZ_UUID, (uint8_t*)&(init->buzz)),
              mac(MAC_RED_UUID, (uint8_t*)&(init->leds[0]), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
#else
              buzz(BUZZ_UUID, &(init->buzz), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
              redLed(MAC_RED_UUID, &(init->leds[0]), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
#endif
              green_led(GREEN_UUID, &(init->leds[1]), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
              blue_led(BLUE_UUID, &(init->leds[2]), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
              acc_lsb(ACC_LSB_UUID, &(init->acc_lsb), GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
              acc_data(ACC_DATA_UUID, init->acc_data, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
        {
            GattCharacteristic *charTable[] = {
#if VODAFONE_COMPATIBILITY == 1
                &buzz, &mac,
#else
                &buzz, &redLed,
#endif
                &green_led, &blue_led, &acc_lsb, &acc_data};     // Add characteristick in table
            GattService AckService(LIZZY_SERVICE_UUID, charTable, sizeof(charTable)/sizeof(GattCharacteristic *));   
            ble.gattServer().addService(AckService); // Add service in the BLE
        }
        
        inline BLEDevice *get_ble(){
            return &ble;
        }
        
        // Characteristic setters.
/*
        inline void set_buzz_state(bool new_state){
            ble.gattServer().write(buzz.getValueHandle(), (uint8_t*)&new_state, sizeof(new_state));
        }
        inline void set_red_state(bool new_state){
            ble.gattServer().write(red_led.getValueHandle(), (uint8_t*)&new_state, sizeof(new_state));
        }*/
        inline void set_green_state(bool new_state){
            ble.gattServer().write(green_led.getValueHandle(), (uint8_t*)&new_state, sizeof(new_state));
        }
        inline void set_blue_state(bool new_state){
            ble.gattServer().write(blue_led.getValueHandle(), (uint8_t*)&new_state, sizeof(new_state));
        }
        
        inline void set_acc_lsb(uint16_t new_value){
            ble.gattServer().write(acc_lsb.getValueHandle(), (uint8_t*)&new_value, sizeof(new_value));
        }
        inline void set_acc_data(int16_t *new_values){
            ble.gattServer().write(acc_data.getValueHandle(), (uint8_t*)new_values, sizeof(int16_t)*NUM_AXIS);
        }
        
        // Characteristic getters.
/*
        inline bool get_buzz_state(){
            bool tmp;
            uint16_t size = sizeof(tmp);
            ble.gattServer().read(buzz.getValueHandle(), (uint8_t*)&tmp, &size);
            return tmp;
        }
        inline bool get_red_state(){
            bool tmp;
            uint16_t size = sizeof(tmp);
            ble.gattServer().read(red_led.getValueHandle(), (uint8_t*)&tmp, &size);
            return tmp;
        }*/
        inline bool get_green_state(){
            bool tmp;
            uint16_t size = sizeof(tmp);
            ble.gattServer().read(green_led.getValueHandle(), (uint8_t*)&tmp, &size);
            return tmp;
        }
        inline bool get_blue_state(){
            bool tmp;
            uint16_t size = sizeof(tmp);
            ble.gattServer().read(blue_led.getValueHandle(), (uint8_t*)&tmp, &size);
            return tmp;
        }

/*
        inline GattAttribute::Handle_t get_buzz_handle(){
            return buzz.getValueHandle();
        }
        inline GattAttribute::Handle_t get_red_handle(){
            return red_led.getValueHandle();
        }*/
        inline GattAttribute::Handle_t get_green_handle(){
            return green_led.getValueHandle();
        }
        inline GattAttribute::Handle_t get_blue_handle(){
            return blue_led.getValueHandle();
        }
        
        inline GattAttribute::Handle_t get_acc_lsb_handle(){
            return acc_lsb.getValueHandle();
        }inline GattAttribute::Handle_t get_acc_data_handle(){
            return acc_data.getValueHandle();
        }

#if VODAFONE_COMPATIBILITY == 1
        CHARACTERISTIC_A(WriteOnly, uint8_t, 4, buzz, Buzz);
        CHARACTERISTIC_A(ReadOnly, uint8_t, 6, mac, Mac);
#else
        CHARACTERISTIC_W(ReadWrite, bool, buzz, Buzz);
        CHARACTERISTIC_W(ReadWrite, bool, redLed, RedLed);
#endif
        
    private:
        BLEDevice &ble;
        // Create new characteristics
/*
        ReadWriteGattCharacteristic<bool> buzz;
        ReadWriteGattCharacteristic<bool> red_led;*/
        ReadWriteGattCharacteristic<bool> green_led;
        ReadWriteGattCharacteristic<bool> blue_led;
        
        ReadOnlyGattCharacteristic<uint16_t> acc_lsb;
        ReadOnlyArrayGattCharacteristic<int16_t, NUM_AXIS> acc_data;
};

#endif //__LIZZY_SERVICE_H__