/*
 *   Made by Jurica Resetar @ aconno
 *   More info @ aconno.de
 *
 */

#ifndef MAIN_H
#define MAIN_H
 
#include "mbed.h"
#include "Lis2dh12.h"
#include "Lis2dh12_regs.h"
#include "aconno_ble.h"
#include "ble/BLE.h"
#include "GapAdvertisingData.h"
#include "acd52832_bsp.h"
#include "proj_config.h"

//#define LSB_VALUE           (192)


#define STOP_FPU()                                                             \
  __set_FPSCR(__get_FPSCR()  & ~(0x0000009F));                                 \
  (void) __get_FPSCR();                                                        \
  NVIC_ClearPendingIRQ(FPU_IRQn)

#if PRINT_ON_RTT
    #include "SEGGER_RTT.h"
    #define printf(...)                      SEGGER_RTT_printf(0, __VA_ARGS__)
#else
    #define printf(...)
#endif

    
#define ACC_INT_SIG         (0x00001020)    // Acc interrupt signal
#define DISABLE_BLE_SIG     (0x00001040)


extern Thread bleT;
extern Thread measureT;
extern Thread updateServiceT;
extern Thread updateBuzzLedsT;

void disableI2C();

#endif
