#ifndef __BSP_BUZZ_H__
#define __BSP_BUZZ_H__

#include "main.h"
#include "acn_nrf52_pwm.h"

#if NANO_MODULE
#else
    #define BUZZER_PIN          (p18)
#endif

#define BUZZER_FREQUENCY_HZ       (4000)
#define BUZZ_TIME_S               (2)     /* Buzz time in s */

class Buzz
{
    typedef typeof(NRF_PWM0) NRF_PWM_TYPE;
    
    public:
        
        Buzz(NRF_PWM_TYPE pwmInstance, uint8_t pin) :
        buzzer(pwmInstance), pwm_pin(pin), state(false){}
        
        void enable();
        void disable();
        
        inline bool get_state(){ return state; }
        
    private:
        
        uint8_t pwm_pin;
        NRF52_PWM buzzer;
        
        bool state;
};

#endif //__BSP_BUZZ_H__