
#include "mbed.h"
#include "Lis2dh12.h"
#include "Lis2dh12_regs.h"
#include "bspAcc.h"
#include "main.h"


extern DigitalOut AccVcc;

extern Lis2dh12 mems;

extern InterruptIn INT1;

void init_acc()
{
    INT1.disable_irq();
    //__disable_irq();
    
    AccVcc = 1;
    
    wait_ms(POWER_UP_DELAY_MS);
    
    //__enable_irq();
    
    mems.setMode(LOW_POWER);
    //mems.setMode(HIGH_RES);
    mems.enableAxes(X_axis);
    mems.enableAxes(Y_axis);
    mems.enableAxes(Z_axis);    
    mems.setODR(ACC_ODR_MODE);
    //mems.setScale(_16g);
    mems.setScale(_8g);
    mems.int1Setup(0x40);       // IntActivity 1 driven to INT1 pad
    mems.int1Latch(0x01);       // Enable int1 latch
    mems.int1Threshold(INT1_THRESHOLD); 
    mems.int1Duration(INT1_DUR);            
    mems.int1Config(0x2A);      // Enable XHigh, YHigh and ZHigh
    
    //__enable_irq();
    INT1.enable_irq();
}
