/*
 * Made by Dominik @ aconno
 * All rights reserved
 *
 */

#ifndef __SERVICE_MACROS_H__
#define __SERVICE_MACROS_H__


#define _SERVICE_INIT_T(serv_name)          Init##serv_name
#define SERVICE_INIT_T(serv_name)           _SERVICE_INIT_T(serv_name)


#define CHARACTERISTIC_W(charType, type, var, func)                            \
                                                                               \
public:                                                                        \
                                                                               \
inline GattAttribute::Handle_t get##func##Handle(){                            \
    return var.getValueHandle();                                               \
}                                                                              \
                                                                               \
inline void set##func(const type &new_state){                                  \
    ble.gattServer().write(var.getValueHandle(),                               \
                           (uint8_t*)&new_state,                               \
                           sizeof(type));                                      \
}                                                                              \
                                                                               \
inline void set##func(type *new_state){                                        \
    ble.gattServer().write(var.getValueHandle(),                               \
                           (uint8_t*)new_state,                                \
                           sizeof(type));                                      \
}                                                                              \
                                                                               \
inline type get##func(){                                                       \
    type tmp;                                                                  \
    uint16_t size = sizeof(tmp);                                               \
    ble.gattServer().read(var.getValueHandle(), (uint8_t*)&tmp,                \
                                                          &size);              \
    return tmp;                                                                \
}                                                                              \
                                                                               \
inline type *get##func(type &tmp){                                             \
    uint16_t size = sizeof(type);                                              \
    ble.gattServer().read(var.getValueHandle(), (uint8_t*)&tmp,                \
                                                          &size);              \
    return &tmp;                                                               \
}                                                                              \
                                                                               \
inline type *get##func(type *tmp){                                             \
    uint16_t size = sizeof(type);                                              \
    ble.gattServer().read(var.getValueHandle(), (uint8_t*)tmp,                 \
                                                          &size);              \
    return tmp;                                                                \
}                                                                              \
                                                                               \
private:                                                                       \
charType##GattCharacteristic<type> var


#define CHARACTERISTIC_A(charType, type, size_, var, func)                     \
                                                                               \
public:                                                                        \
                                                                               \
inline GattAttribute::Handle_t get##func##Handle(){                            \
    return var.getValueHandle();                                               \
}                                                                              \
                                                                               \
inline void set##func(type *new_state){                                        \
    ble.gattServer().write(var.getValueHandle(),                               \
                           (uint8_t*)new_state,                                \
                           sizeof(type)*size_);                                \
}                                                                              \
                                                                               \
inline type *get##func(type *tmp){                                             \
    uint16_t size = sizeof(type)*size_;                                        \
    ble.gattServer().read(var.getValueHandle(), (uint8_t*)tmp,                 \
                                                          &size);              \
    return tmp;                                                                \
}                                                                              \
                                                                               \
private:                                                                       \
charType##ArrayGattCharacteristic<type, size_> var

#endif //__SERVICE_MACROS_H__
