/*
*  Made by Jurica Resetar @ aconno
*  More info @ aconno.de
*  jurica_resetar@yahoo.com
*/

#ifndef ACONNO_BLE_H
#define ACONNO_BLE_H

#include "mbed.h"
#include "ble/BLE.h"
#include "GapAdvertisingData.h"
#include "lizzy_service.h"
#include "proj_config.h"

#if VODAFONE_COMPATIBILITY == 1
const uint8_t UUID[16] = {0xE1, 0x61, 0x35, 0xBA, 0xC0, 0xEC, 0x47, 0x2A, 0x98, 0x00, 0xAF, 0x18, 0x43, 0xFF, 0x05, 0x00};
#endif

#define APPLICATION_ID      (0xCF170059) //(0xCF170059)

#define LSB_VALUE           (0xFFFF)    // this is divided by 2^16 in app

/* Global variables and constants */

struct __attribute__((packed, aligned(1))) advertising_packet{
    uint32_t header;
    uint8_t  type;
    union{
        struct{
            int16_t gyroscope[3];
            int16_t accelerometer[3];
            int16_t magnetometer[3];
            uint16_t acc_lsb_value;
        };
        struct{
            float temperature;
            float humidity;
            float pressure;
            float light;
            uint8_t battery;
        };
    };
};

extern LizzyService *lizzy_service;

/* Function declarations */
EventQueue *getBLEEventQueue(void);
bool bleIsClientConnected(void);
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params);
void updatePayload(BLE *ble, advertising_packet *advertisementPacket);


#endif      //ACONNO_BLE_H