#include "mbed.h"
#include "LSM9DS1.h"
#include "LSM9DS1_RegVals.h"
#include "acd52832_bsp.h"

LSM9DS1::LSM9DS1(I2C *i2c){
    _i2c = i2c;
} 

void LSM9DS1::startMagnetometer(){
    char data[2];

    data[0] = (char)CTRL_REG1_M;          // Target register
    data[1] = (char)0x7C;                 // Data to write
    _i2c->write(TWI_MAG_ADDR, data, 0x02,0);

    data[0] = (char)CTRL_REG2_M;          // Target register
    data[1] = (char)0x00;                 // Full scale for the sensor (+-4g)
    _i2c->write(TWI_MAG_ADDR, data, 0x02,0); 

    data[0] = (char)CTRL_REG3_M;          // Target register
    data[1] = (char)0x00;                 // Data to write
    _i2c->write(TWI_MAG_ADDR, data, 0x02,0);

    data[0] = (char)CTRL_REG4_M;          // Target register
    data[1] = (char)(3<<3);                 // Data to write
    _i2c->write(TWI_MAG_ADDR, data, 0x02,0);

    data[0] = (char)CTRL_REG5_M;          // Target register
    data[1] = (char)0x00;                 // Data to write
    _i2c->write(TWI_MAG_ADDR, data, 0x02,0);
}

void LSM9DS1::readMagnetometer(int16_t *results){
    char results_[6];
    int16_t resultFinal[3];
    char out_x_l_m = OUT_X_L_M;
    
    _i2c->write(TWI_MAG_ADDR, &out_x_l_m, 1, true);
    _i2c->read(TWI_MAG_ADDR, results_, 6, 0);
    resultFinal[0] = ((results_[1]<<8) | results_[0]);
    resultFinal[1] = ((results_[3]<<8) | results_[2]);
    resultFinal[2] = ((results_[5]<<8) | results_[4]);
    
    *(results) = resultFinal[0];
    *(results + 1) = resultFinal[1];
    *(results + 2) = resultFinal[2];
}

void LSM9DS1::startAccelerometer(){
    char data[2];
    
    data[0] = (char)CTRL_REG5_XL;          // Target register
    data[1] = (char)0x38;                 // Data to write
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
     
    
    data[0] = (char)CTRL_REG6_XL;          // Target register
    data[1] = (char)0xC7;                  // +-2g -> See reference manual for more info (page 52) 
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
}

void LSM9DS1::readAccelerometer(int16_t *results){
    char results_[6];
    int16_t resultFinal[3];
    char out_x_l_xl = OUT_X_L_XL;
    
    _i2c->write(TWI_AG_ADDR, &out_x_l_xl, 1, true);
    _i2c->read(TWI_AG_ADDR, results_, 6, 0);
    resultFinal[0] = ((results_[1]<<8) | results_[0]);
    resultFinal[1] = ((results_[3]<<8) | results_[2]);
    resultFinal[2] = ((results_[5]<<8) | results_[4]);
    
    *(results) = resultFinal[0];
    *(results + 1) = resultFinal[1];
    *(results + 2) = resultFinal[2];
}

void LSM9DS1::startGyroscope(){
    char data[2];
    
    data[0] = (char)CTRL_REG6_XL;                  // Target register
    data[1] = (char)0xC7 & (char)0x1F;             // Data to write
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
    
    data[0] = (char)CTRL_REG1_G;          // Target register
    data[1] = (char)0xC0;                 // 245 DPS scale
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
     
    
    data[0] = (char)CTRL_REG2_G;          // Target register
    data[1] = (char)0x00;                 // Data to write
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
     
    
    data[0] = (char)CTRL_REG3_G;          // Target register
    data[1] = (char)0x00;                 // Data to write
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
     
    
    data[0] = (char)CTRL_REG4;            // Target register
    data[1] = (char)0x3A;                 // Data to write
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
     
    
    data[0] = (char)ORIENT_CFG_G;          // Target register
    data[1] = (char)0x00;                 // Data to write
    _i2c->write(TWI_AG_ADDR, data, 0x02,0);
     
}

void LSM9DS1::readGyroscope(int16_t *results){
    char results_[6];
    int16_t resultFinal[3];
    char out_x_l_g = OUT_X_L_G;
    
    _i2c->write(TWI_AG_ADDR, &out_x_l_g, 1, true);
    _i2c->read(TWI_AG_ADDR, results_, 6, 0);
    resultFinal[0] = ((results_[1]<<8) | results_[0]);
    resultFinal[1] = ((results_[3]<<8) | results_[2]);
    resultFinal[2] = ((results_[5]<<8) | results_[4]);
    
    *(results) = resultFinal[0];
    *(results + 1) = resultFinal[1];
    *(results + 2) = resultFinal[2];
}