#include "mbed.h"
#include "BLEDevice.h"
#include "CustomService.h"


// BLE object
BLEDevice ble;

// LED object
DigitalOut led(LED1);

const static char     DEVICE_NAME[]        = "MyDeviceName"; // change this
static const uint16_t uuid16_list[]        = {0xFF}; //Custom UUID, FF is reserved for development

// Set Up Characteristics
static uint8_t readValue[1] = {0x00};
GattCharacteristic readChar(0xAAAA /* read char UUID*/, readValue, sizeof(readValue), sizeof(readValue),
                        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

static uint8_t writeValue[1] = {0x00};
GattCharacteristic writeChar(0xBBBB /*write char UUID*/, writeValue, sizeof(writeValue), sizeof(writeValue),
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

GattCharacteristic *characteristics[] = {&readChar, &writeChar};

// Set up custom service
GattService        customService(0x221D /*Service UUID*/, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));


// Restart advertising when phone app disconnects
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}

// This function is called whenever someone writes something to the writeCharacteristic
void writeCharCallback(const GattCharacteristicWriteCBParams *params)
{
    led = params->data[0];
    printf("LED Written To, value=%x",params->data[0]);
    // TODO: update the readChar value to match write char, or better yet give it an english value
}

int
main(void)
{
    led = 0;    // turn LED off
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(writeCharCallback); //TODO: this is not correct, figure out correct syntax

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising(); // start advertising

    ble.addService(customService); // Add our custom service to device

    while (true) {
        ble.waitForEvent(); //Save power
    }
    
    
    // TODO: impliment the rest of triggering for LED based on Write of characteristic.
    // TODO: impliment a read characteristic that sends text back to app
    // take a look at http://developer.mbed.org/teams/Bluetooth-Low-Energy/code/BLE_GroveColourSensor/file/000c8f8c7f03/main.cpp for inspiration.
}