#include "mbed.h"

DigitalOut greenLed(LED_GREEN);
DigitalOut redLed(LED_RED);

Serial pc(USBTX, USBRX);
Serial uart1(P1_8, P1_2);

uint8_t buffer[256];
uint16_t bufferIndex = 0;
uint8_t data;
uint32_t ledToggleTime;

int main()
{
    pc.baud(115200);
    pc.printf("\r\n\r\nProgram started\r\nType some text and press ENTER ...\r\n");
    
    memset(buffer, 0, sizeof(buffer));
    redLed = 1;
    ledToggleTime = 0;
    
    uart1.baud(115200);
    pc.printf("Type text > "); // show the prompt
    
    for(;;)
    {
        while (uart1.readable() > 0)
        {
            pc.printf("\r\nreadable(): %d\r\n", uart1.readable());
            
            data = uart1.getc();
            pc.printf("\r\n<<< [%02X]\r\n", data);
        }
        
        while (pc.readable() > 0)
        {
            if (bufferIndex < sizeof(buffer))
            {
                redLed = 1; // turn off the red led
                data = pc.getc();
                
                // wait for ENTER
                if ((data == 0x0d) || (data == 0x0a))
                {
                    if (bufferIndex > 0)
                    {
                        pc.printf("\r\nGot it: %s\r\n", buffer);
                        
                        pc.printf("\r\n>>> %s\r\n", buffer);
                        uart1.printf("%s", buffer);
                        
                        memset(buffer, 0, sizeof(buffer));
                        bufferIndex = 0;
                    }
                    
                    pc.printf("\r\nType text > "); // show the prompt
                }
                else
                {
                    buffer[bufferIndex++] = data;
                    pc.putc(data);
                }
            }
            else
            {
                redLed = 0; // turn on the red led
            }
        }

        // toggle green led every 500 ms        
        if ((us_ticker_read() - ledToggleTime)/1000 >= 500)
        {
            ledToggleTime = us_ticker_read();
            greenLed = !greenLed;
        }
    }
}
