// Testing MBED with Daniel
#include "mbed.h"
#include "Blinker.h"
#include "TextLCD.h"

Timer timer;
DigitalOut led1(LED1);
AnalogIn volatage(A0);
//DigitalOut greenLed(D8);
//DigitalOut redLed(D10);
//DigitalIn button(D9);

Serial pc(USBTX, USBRX);
jj::Blinker blinker1(led1, timer);

TextLCD lcd(D2, D3, D4, D5, D6, D7, TextLCD::LCD20x4); // rs, e, d4-d7
float prevVoltage = 0;

int main()
{
    timer.start();
    pc.baud(115200);
    pc.printf("Hello world\r\n");
    
    blinker1.blink(200, 1000);
    
    lcd.cls();
    
    for(;;)
    {
        blinker1.update();
        
        float v = volatage.read() * 3.3f;
        if (abs(v - prevVoltage) > 0.1f)
        {
            lcd.locate(14, 0);
            lcd.printf("%0.2f V", v);
        }
        prevVoltage = v;
    }
}
