/** 
 * @file    Blinker.h
 * @brief   Digital pin blinking library
 * @author  Jurgis Jurksta
 * @version 1.0.0
 * @see     
 *
 * Copyright (c) 2017, Jurgis Jurksta
 */

#ifndef JJ_BLINKER_H
#define JJ_BLINKER_H

#include "mbed.h"

namespace jj
{
    /** Digital pin blinking class
     */
    class Blinker
    {
        public:
            Blinker(DigitalOut& pin, Timer& timer);
            void update();
            void on();
            void off();
            void blink(int onTimeMs, int offTimeMs);
            void blink(int timeMs);
            
        private:
            DigitalOut& _pin;
            Timer& _timer;
            bool _blink;
            int _onTimeMs;
            int _offTimeMs;
            uint32_t _lastToggleTimeMs;
    };
}

#endif
