/** 
 * @file    Blinker.cpp
 * @brief   Digital pin blinking library
 * @author  Jurgis Jurksta
 * @version 1.0.0
 * @see     
 *
 * Copyright (c) 2017, Jurgis Jurksta
 */

#include "Blinker.h"

namespace jj
{
    Blinker::Blinker(DigitalOut& pin, Timer& timer)
        : _pin(pin), _timer(timer)
    {
        _blink = false;
    }
    
    
    void Blinker::update()
    {
        // do not proceed if blinking is not allowed
        if (_blink == false)
            return;

        bool pinIsOn = _pin == 1;
        int toggleTimeMs = pinIsOn ? _onTimeMs : _offTimeMs;

        if (_timer.read_ms() - _lastToggleTimeMs >= toggleTimeMs)
        {
            _lastToggleTimeMs = _timer.read_ms();
            _pin = !_pin;
        }
    }


    void Blinker::on()
    {
        _blink = true;
        _pin = 1;
    }
    
    
    void Blinker::off()
    {
        _blink = false;
        _pin = 0;
    }


    void Blinker::blink(int onTimeMs, int offTimeMs)
    {
        _blink = true;
        _onTimeMs = onTimeMs;
        _offTimeMs = offTimeMs;
        _lastToggleTimeMs = _timer.read_ms();
    }


    void Blinker::blink(int timeMs)
    {
        blink(timeMs, timeMs);
    }
}
