/**********************************************
MIDN Justin Park and Drew Moore
10 March 2016
SY202 Lab 8 Part 2
Description: This function calculates the time
                a single pulse takes and converts
                the time into distance in an 
                Ultrasonic sensor.
*********************************************/
#include "mbed.h"
#include "C12832_lcd.h"

//Initialize the LCD display
C12832_LCD lcd;

InterruptIn pw_event(p21); // Declare a pulse width object
Timer t; // Declare a timer object

//Initialize float variables
float distance; // Variable to store distance from the sensor
float us = 0; // Variable to store microseconds

// Function to store the time measured from the timer
void getPw(){
   us = t.read_us();
    }

// Function to reset and start the timer
void rise_int(){
    t.reset();
    t.start();
    }

int main() {
    while(1) {
        
        // Obtain the microseconds it takes for the pulse
        // to achieve its rise and fall time
        pw_event.rise(&rise_int);
        pw_event.fall(&getPw);
        
        // Formula based on calibration calculated from the 
        // excel spreadsheet
        distance = 0.0066 * us + 0.9024;
        
        // Print distance to the LCD display
        lcd.locate(0,0);
        lcd.printf("%f", distance);
        
    }
}


